/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram.messages;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.vavilon.app.telegram.model.Message;
import org.vavilon.app.telegram.model.MessageFrequency;
import org.vavilon.app.telegram.model.MessagePriority;
import org.vavilon.app.telegram.model.TelegramUser;

public class InactivityAlert {
    private static final Map<String, Map<Long, Message>> messages = new HashMap<String, Map<Long, Message>>();
    static int MAX_ONBOARDING_ENERGY_COUNT = 5;

    private static void addMessage(UserLevel level, Duration inactivity, String template, MessagePriority priority, MessageFrequency frequency, Object params) {
        messages.computeIfAbsent(level.name(), a -> new HashMap()).put(inactivity.getSeconds(), new Message(template, priority, frequency, params));
    }

    public static UserLevel getLevel(TelegramUser user) {
        if (user.total_deposited == 0.0) {
            if (user.buy_energy_count == (long)MAX_ONBOARDING_ENERGY_COUNT) {
                return UserLevel.SLEEPED_ONBOARDED;
            }
            if (user.buy_energy_count > (long)MAX_ONBOARDING_ENERGY_COUNT) {
                return UserLevel.SLEEPED_PAYER;
            }
        } else {
            return UserLevel.DEPOSIT;
        }
        return UserLevel.SLEEPED_GUEST;
    }

    public static Message getMessage(TelegramUser user) {
        try {
            Map<Long, Message> messageList = messages.get(InactivityAlert.getLevel(user).name());
            if (messageList == null) {
                return null;
            }
            long inactivitySeconds = System.currentTimeMillis() - user.last_activity_date;
            Long closestKey = null;
            for (Long key : messageList.keySet()) {
                if (inactivitySeconds < key || closestKey != null && key <= closestKey) continue;
                closestKey = key;
            }
            return closestKey != null ? messageList.get(closestKey) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        InactivityAlert.addMessage(UserLevel.SLEEPED_GUEST, Duration.ofDays(1L), "finish_onboarding", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_YEAR, null);
        InactivityAlert.addMessage(UserLevel.SLEEPED_ONBOARDED, Duration.ofHours(1L), "collect_your_tokens", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_YEAR, null);
        InactivityAlert.addMessage(UserLevel.SLEEPED_PAYER, Duration.ofHours(1L), "collect_your_tokens", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_YEAR, null);
    }

    public static enum UserLevel {
        SLEEPED_GUEST,
        SLEEPED_ONBOARDED,
        SLEEPED_PAYER,
        REFERRAL,
        DEPOSIT;

    }
}

