/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.model.chain.BigChainCell;

public class BigChain<Type extends BigChainCell>
extends BigMap<Type> {
    public BigArray<Type> history;

    public BigChain(String app, String filename, Class<Type> type) {
        super(app, filename, type);
        this.history = new BigArray<Type>(app, filename + ".history", type);
    }

    public void addLast(String key, Type value) {
        BigChainCell lastItem = (BigChainCell)this.get(key);
        if (lastItem == null) {
            lastItem = (BigChainCell)this.values.createValInstance();
        } else {
            ((BigChainCell)value).prev_index = this.history.add(lastItem) + 1L;
        }
        ((BigChainCell)value).history_index = lastItem.history_index + 1L;
        ((BigChainCell)value).key = key;
        this.put(key, value);
    }

    public List<Type> getPageReverse(String key, Long offsetFromStart, Long sizeFromOffsetToStart) {
        ArrayList<BigChainCell> result = new ArrayList<BigChainCell>();
        BigChainCell current = (BigChainCell)this.get(key);
        if (current == null) {
            return result;
        }
        if (offsetFromStart == null || offsetFromStart <= 0L) {
            offsetFromStart = current.history_index;
        }
        if (offsetFromStart > current.history_index) {
            return result;
        }
        while (current != null && current.history_index > offsetFromStart) {
            if (current.prev_index == 0L) {
                current = null;
                continue;
            }
            current = (BigChainCell)this.history.get(current.prev_index - 1L);
        }
        while (current != null && (long)result.size() < sizeFromOffsetToStart) {
            result.add(current);
            if (current.prev_index == 0L) {
                current = null;
                continue;
            }
            current = (BigChainCell)this.history.get(current.prev_index - 1L);
        }
        return result;
    }

    public long getCount(String key) {
        BigChainCell lastItem = (BigChainCell)this.get(key);
        return lastItem == null ? 0L : lastItem.history_index;
    }

    public Type getLast(String key) {
        List<Type> last = this.getListFromEnd(key, 1L);
        return (Type)(!last.isEmpty() ? (BigChainCell)last.get(0) : null);
    }

    public List<Type> getListFromEnd(String key, Long size) {
        ArrayList<BigChainCell> result = new ArrayList<BigChainCell>();
        BigChainCell lastValue = (BigChainCell)this.get(key);
        if (lastValue == null) {
            return result;
        }
        result.add(lastValue);
        size = size - 1L;
        try {
            while (lastValue.prev_index != 0L && size > 0L) {
                lastValue = (BigChainCell)this.history.get(lastValue.prev_index - 1L);
                result.add(lastValue);
                Long l = size;
                size = size - 1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void forEachFromEnd(String key, Consumer<Type> callback) {
        BigChainCell current = (BigChainCell)this.get(key);
        if (current == null) {
            return;
        }
        callback.accept(current);
        while (current.prev_index != 0L) {
            try {
                current = (BigChainCell)this.history.get(current.prev_index - 1L);
                callback.accept(current);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

