/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import com.google.common.primitives.Bytes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BigFile {
    final long BLOCK_SIZE = 0x400000L;
    private String filename;
    private final File dir;
    public long fileSize = 0L;
    public Map<Integer, RandomAccessFile> blocks = new HashMap<Integer, RandomAccessFile>();
    protected Long maxBlocks = Long.MAX_VALUE;

    public BigFile(String filepath, String filename) {
        if (filepath == null || filename == null) {
            throw new NullPointerException();
        }
        if (filename.contains("\\")) {
            filename = filename.replace("\\", "/");
        }
        if (filename.contains("/")) {
            filename = filename.replace("/", "_");
        }
        this.filename = filename;
        this.dir = new File(filepath);
        this.dir.mkdirs();
        this.calculateFileSize();
    }

    public BigFile(String app, String filename, Long maxBlocks) {
        this(app, filename);
        this.maxBlocks = maxBlocks;
        if (maxBlocks < 2L) {
            throw new IllegalArgumentException("maxBlocks must be at least 2");
        }
    }

    private void calculateFileSize() {
        this.fileSize = 0L;
        boolean needAddFirstBlockSize = false;
        int index = 0;
        while (true) {
            File blockFile;
            if ((blockFile = new File(this.dir, this.filename + index + ".bin")).exists()) {
                try {
                    long blockSize = blockFile.length();
                    if (blockSize == 0L) {
                        if (index == 0) {
                            needAddFirstBlockSize = true;
                        } else {
                            blockSize = 0x400000L;
                        }
                    }
                    this.fileSize += blockSize;
                }
                catch (Exception exception) {}
            } else {
                if (!needAddFirstBlockSize) break;
                this.fileSize += 0x400000L;
                break;
            }
            ++index;
        }
    }

    RandomAccessFile getFile(int index) {
        RandomAccessFile blockRandomFile = this.blocks.get(index);
        if (blockRandomFile == null) {
            try {
                File blockFile = new File(this.dir, this.filename + index + ".bin");
                blockRandomFile = new RandomAccessFile(blockFile, "rw");
                this.blocks.put(index, blockRandomFile);
                if ((long)this.blocks.size() > this.maxBlocks) {
                    Integer minBlockNumber = Collections.min(this.blocks.keySet());
                    try {
                        this.blocks.get(minBlockNumber).setLength(0L);
                        this.blocks.get(minBlockNumber).close();
                        this.blocks.remove(minBlockNumber);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return blockRandomFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(long start, long length) {
        BigFile bigFile = this;
        synchronized (bigFile) {
            long end = start + length;
            if (end > this.fileSize) {
                return null;
            }
            int startFileIndex = (int)(start / 0x400000L);
            int endFileIndex = (int)(end / 0x400000L);
            if (startFileIndex == endFileIndex) {
                RandomAccessFile readingFile = this.getFile(startFileIndex);
                int startInFile = (int)(start % 0x400000L);
                return this.readFromFile(readingFile, startInFile, (int)length);
            }
            RandomAccessFile firstFile = this.getFile(startFileIndex);
            RandomAccessFile secondFile = this.getFile(endFileIndex);
            int lengthInSecondFile = (int)(end % 0x400000L);
            int lengthInFirstFile = (int)(length - (long)lengthInSecondFile);
            int startInFirstFile = (int)(start % 0x400000L);
            byte[] dataFromFirstFile = this.readFromFile(firstFile, startInFirstFile, lengthInFirstFile);
            byte[] dataFromSecondFile = this.readFromFile(secondFile, 0L, lengthInSecondFile);
            return Bytes.concat((byte[][])new byte[][]{dataFromFirstFile, dataFromSecondFile});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(long start, byte[] data) {
        BigFile bigFile = this;
        synchronized (bigFile) {
            long length = data.length;
            long end = start + length;
            if (start > this.fileSize) {
                return;
            }
            int startFileIndex = (int)(start / 0x400000L);
            int endFileIndex = (int)(end / 0x400000L);
            RandomAccessFile firstWriteFile = this.getFile(startFileIndex);
            RandomAccessFile secondWriteFile = this.getFile(endFileIndex);
            if (start == this.fileSize) {
                this.fileSize += (long)data.length;
            }
            if (startFileIndex == endFileIndex) {
                int startInFile = (int)(start - (long)startFileIndex * 0x400000L);
                this.writeToFile(firstWriteFile, startInFile, data);
            } else {
                int lengthInSecondFile = (int)(end % 0x400000L);
                int lengthInFirstFile = (int)(length - (long)lengthInSecondFile);
                int startInFirstFile = (int)(start % 0x400000L);
                byte[] dataToFirstFile = new byte[lengthInFirstFile];
                byte[] dataToSecondFile = new byte[lengthInSecondFile];
                System.arraycopy(data, 0, dataToFirstFile, 0, lengthInFirstFile);
                System.arraycopy(data, lengthInFirstFile, dataToSecondFile, 0, lengthInSecondFile);
                this.writeToFile(firstWriteFile, startInFirstFile, dataToFirstFile);
                this.writeToFile(secondWriteFile, 0L, dataToSecondFile);
            }
        }
    }

    byte[] readFromFile(RandomAccessFile file, long offset, int length) {
        try {
            file.seek(offset);
            byte[] data = new byte[length];
            file.read(data);
            return data;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    void writeToFile(RandomAccessFile file, long offset, byte[] data) {
        try {
            file.seek(offset);
            file.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long addBytes(byte[] data) {
        this.writeBytes(this.fileSize, data);
        return this.fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFiles() {
        BigFile bigFile = this;
        synchronized (bigFile) {
            File blockFile;
            for (RandomAccessFile raf : this.blocks.values()) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.blocks.clear();
            int index = 0;
            while ((blockFile = new File(this.dir, this.filename + index + ".bin")).exists()) {
                if (!blockFile.delete()) {
                    System.err.println("Failed to delete file: " + blockFile.getAbsolutePath());
                }
                ++index;
            }
            this.fileSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFiles(String newFilename) {
        BigFile bigFile = this;
        synchronized (bigFile) {
            File oldFile;
            for (RandomAccessFile raf : this.blocks.values()) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.blocks.clear();
            int index = 0;
            while ((oldFile = new File(this.dir, this.filename + index + ".bin")).exists()) {
                File newFile = new File(this.dir, newFilename + index + ".bin");
                if (!oldFile.renameTo(newFile)) {
                    System.err.println("Failed to rename file: " + oldFile.getAbsolutePath());
                }
                ++index;
            }
            this.filename = newFilename;
            this.calculateFileSize();
        }
    }
}

