/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.model.BigArrayCell;
import org.vavilon.gdb.model.String64;

public class Top<Type extends TopId> {
    private final BigArray<String64> topIds;
    private final BigMap<Type> storage;
    private final Comparator<Type> comparator;
    private final int maxSize;

    public Top(String app, String filename, BigMap<Type> storage, Comparator<Type> comparator, int maxSize) {
        this.storage = storage;
        this.topIds = new BigArray<String64>(app, filename, String64.class);
        this.comparator = comparator;
        this.maxSize = maxSize;
    }

    public void add(Type newItem) {
        try {
            int i;
            List<Type> result = this.getTop();
            boolean isUpdated = false;
            for (i = 0; i < result.size(); ++i) {
                if (!((TopId)result.get(i)).getId().equals(newItem.getId())) continue;
                result.set(i, newItem);
                isUpdated = true;
                break;
            }
            if (!isUpdated) {
                result.add(newItem);
            }
            result.sort(this.comparator);
            Collections.reverse(result);
            for (i = 0; i < result.size(); ++i) {
                TopId item = (TopId)result.get(i);
                String64 id = new String64(item.getId());
                if (this.topIds.size() < (long)this.maxSize) {
                    this.topIds.set(i, id);
                    continue;
                }
                this.topIds.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Type> getTop() {
        ArrayList<TopId> result = new ArrayList<TopId>();
        for (long i = 0L; i < Math.min(this.topIds.size(), (long)this.maxSize); ++i) {
            String64 key = this.topIds.get(i);
            TopId existing = (TopId)this.storage.get(key.toString());
            if (existing == null) continue;
            result.add(existing);
        }
        return result;
    }

    public static interface TopId
    extends BigArrayCell {
        public String getId();
    }
}

