/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gpt;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.gpt.CoderTask;
import org.vavilon.gpt.Gpt;
import org.vavilon.token.utils.Utils;

public class Refactor
implements Runnable {
    static List<String> EXCEPTIONS = Utils.list("strings", "utils", "tests");

    static boolean isException(String filepath) {
        for (String exception : EXCEPTIONS) {
            if (!filepath.contains("/" + exception)) continue;
            return true;
        }
        return false;
    }

    public static void optimize(List<String> files, List<String> context) {
        for (String filepath : files) {
            try {
                if (Refactor.isException(filepath)) continue;
                Utils.writeFile(filepath, Gpt.gpt("\u0418\u0441\u043f\u0440\u0430\u0432\u044c \u0433\u0440\u0443\u0431\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0435\u0441\u043b\u0438 \u043e\u043d\u0438 \u0435\u0441\u0442\u044c", context, filepath));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        ArrayList<String> context = new ArrayList<String>();
        context.addAll(CoderTask.JAVA_CONTEXT);
        context.add("\u0443\u0431\u0435\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u044b \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f");
        Refactor.optimize(Utils.getFilesRecAbsolute("c:/wamp/www/node_modules/java-exchange/", "java"), context);
        for (String dir : Utils.getDirectories("c:/wamp/www/node_modules/", "mfm-")) {
            Refactor.optimize(Utils.getFilesAbsolute("c:/wamp/www/node_modules/" + dir, "js"), CoderTask.JS_CONTEXT);
        }
    }

    public static void main(String[] args) {
        new Refactor().run();
    }
}

