/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.servers;

import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class WssClient {
    private WebSocketClient wsClient;
    private final URI wsUri;
    private final Callback callback;
    private final ClientUpgradeRequest upgradeRequest;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public WssClient(String host, Callback callback) throws Exception {
        this(host, callback, null);
        System.out.println("wss init " + this.wsUri);
    }

    public WssClient(String host, Callback callback, ClientUpgradeRequest upgradeRequest) throws Exception {
        if (!host.contains("://")) {
            host = host.contains("localhost") ? "ws://" + host + "/ws" : "wss://" + host + "/ws";
        }
        this.wsUri = new URI(host);
        this.callback = callback;
        this.upgradeRequest = upgradeRequest;
    }

    public void start() throws Exception {
        this.connect();
    }

    public void stop() throws Exception {
        if (this.wsClient != null) {
            this.wsClient.stop();
        }
    }

    private void scheduleReconnect() {
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.connect();
            }
            catch (Exception e) {
                System.err.println("reconnect failed: " + e.getMessage());
                this.scheduleReconnect();
            }
        }).start();
    }

    private void connect() throws Exception {
        System.out.println("attempting to connect " + this.wsUri + " " + this.formatter.format(LocalDateTime.now()));
        if (this.wsClient != null) {
            this.wsClient.stop();
        }
        this.wsClient = new WebSocketClient();
        this.wsClient.setIdleTimeout(Duration.ofMinutes(5L));
        this.wsClient.start();
        this.wsClient.connect((Object)new SocketListener(this.callback), this.wsUri, this.upgradeRequest).get();
    }

    public void send(String message) {
        try {
            for (Session session : this.wsClient.getOpenSessions()) {
                session.sendText(message, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback {
        public void onOpen(Session var1);

        public void onMessage(String var1);
    }

    @WebSocket
    public class SocketListener {
        private final Callback callback;

        public SocketListener(Callback callback) {
            this.callback = callback;
        }

        @OnWebSocketOpen
        public void OnWebSocketOpen(Session session) {
            this.callback.onOpen(session);
        }

        @OnWebSocketMessage
        public void onWebSocketText(Session session, String messageStr) {
            this.callback.onMessage(messageStr);
        }

        @OnWebSocketClose
        public void OnWebSocketClose(int statusCode, String reason) {
            System.out.println("onClose " + reason);
            WssClient.this.scheduleReconnect();
        }
    }
}

