/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vavilon.charts.PostChart;
import org.vavilon.gdb.BigChain64;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.MultiTop;
import org.vavilon.gdb.SearchIndex;
import org.vavilon.gdb.Top;
import org.vavilon.gdb.model.chain.String64ChainCell;
import org.vavilon.servers.WssServer;
import org.vavilon.token.Node;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.DepositListener;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.utils.Base58;
import org.vavilon.token.utils.Base64;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class Send
extends PostChart {
    public static final String APP = "tokens";
    public static final String GENESIS_ADDRESS = "owner";
    public static final String NUMBER_CHARS = "0123456789";
    public static final String ENG_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    public static final String DOMAIN_CHARS = "0123456789abcdefghijklmnopqrstuvwxyz_";
    public static final String REQUESTS_FILENAME = "requests.json";
    public static final String REQUESTS_ACTIVE = "db-tokens/requests.json";
    public static final BigMap<Transaction> transByHash;
    public static final BigMap<Token> tokensByDomain;
    private static final BigMap<Account> accounts;
    public static final MultiTop<Account> topAccounts;
    protected static final SearchIndex tokensSearch;
    public static final BigChain64 userDomains;
    public static final BigChain64 userTrans;
    private static final BigChain64 fromToTransByDomain;
    public static final Top<Token> topMining;
    public static final List<DepositListener> depositListeners;
    public static final List<DepositListener> loaderListeners;
    public Map<String, Account> accountsNew = new HashMap<String, Account>();
    public List<Transaction> transactionsNew = new ArrayList<Transaction>();
    public List<Token> tokensNew = new ArrayList<Token>();

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        String from = this.getString("from", GENESIS_ADDRESS);
        String to = this.getRequired("to");
        Double amount = this.getDouble("amount", 0.0);
        String pass = this.getRequired("pass");
        String delegate = this.getString("delegate");
        if (this.scriptPath == null) {
            this.time();
        }
        this.tokenSend(this.scriptPath, domain, from, to, amount, pass, delegate);
    }

    public static String hashAddress(String password) {
        return Send.address(Utils.hash(password));
    }

    public static String address(String addressBase64) {
        byte[] hash = Base64.decode(addressBase64);
        byte[] addressBytes = new byte[20];
        System.arraycopy(hash, hash.length - 20, addressBytes, 0, 20);
        return "V" + Base58.encode(addressBytes);
    }

    public static String tokenKey(String domain, String address, String password, String prevKey) {
        return Utils.hash(domain + address + password + (prevKey == null ? "" : prevKey));
    }

    public static String tokenNextHash(String domain, String address, String password, String prevKey) {
        return Utils.hash(Send.tokenKey(domain, address, password, prevKey));
    }

    public static String tokenStartPass(String domain, String address, String password) {
        return ":" + Send.tokenNextHash(domain, address, password, "");
    }

    public static String tokenPass(String domain, String address, String password, String prevKey) {
        String key = Send.tokenKey(domain, address, password, prevKey);
        String nextHash = Send.tokenNextHash(domain, address, password, key);
        return key + ":" + nextHash;
    }

    public static String tokenPass(String domain, String address, String password) {
        Account account = Send.getAccount(domain, address);
        return Send.tokenPass(domain, address, password, account == null ? null : (account.prev_key == null ? "" : account.prev_key));
    }

    protected String tokenPassCached(String domain, String address, String password) {
        Account account = this.getAccountChanced(domain, address);
        return Send.tokenPass(domain, address, password, account == null ? null : (account.prev_key == null ? "" : account.prev_key));
    }

    private void setTran(Transaction tran) {
        this.transactionsNew.add(tran);
    }

    public static Token getToken(String domain) {
        Token token = tokensByDomain.get(domain);
        if (token != null) {
            token = token.clone();
        }
        return token;
    }

    public void setToken(Token token) {
        this.tokensNew.add(token);
    }

    public static Account getAccount(String domain, String address) {
        return accounts.get(domain + address);
    }

    protected Account getAccountChanced(String domain, String address) {
        Account account = this.accountsNew.get(domain + address);
        if (account == null) {
            account = Send.getAccount(domain, address);
        }
        return account;
    }

    private void setAccountCached(Account account) {
        this.accountsNew.put(account.domain + account.address, account);
    }

    public static List<Account> getSubAccounts(String address) {
        ArrayList<Account> result = new ArrayList<Account>();
        List<String> domains = userDomains.getStringsFromEnd(address, 20L);
        for (String domain : domains) {
            Account account = Send.getAccount(domain, address);
            if (account == null) continue;
            account.token = Send.getToken(domain);
            result.add(account);
        }
        return result;
    }

    public void validateDomain(String domain) {
        if (domain == null) {
            Utils.error("domain is null");
        }
        if (domain.length() < 3 || domain.length() > 32) {
            Utils.error("domain length has to be between 3 and 32");
        }
        if (!Utils.isValidChars(domain, DOMAIN_CHARS)) {
            Utils.error("domain has to contain only english letters, numbers and underscore");
        }
    }

    public boolean validateAddress(String address) {
        if (address == null) {
            Utils.error("address is null");
        }
        if (!address.startsWith("V")) {
            Utils.error("first symbol in address has to be V");
        }
        if (Base58.decode(address.substring(1)).length != 20) {
            Utils.error("after base58 decode size has to be 20");
        }
        return true;
    }

    private void validateContract(String delegate) {
        if (Utils.isEmpty(delegate)) {
            return;
        }
        if (delegate.startsWith("/")) {
            Utils.error("contract has not be starts from /");
        }
    }

    public static List<Transaction> getTrans(String domain, String from, String to, Long offset, Long size) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        size = Math.max(Math.min(size, 100L), 1L);
        List hashes = Utils.isNotEmpty(domain) && Utils.isNotEmpty(to) ? fromToTransByDomain.getPageReverse(domain + from + to, offset, size) : userTrans.getPageReverse(from, offset, size);
        for (String64ChainCell next_hash : hashes) {
            Transaction tran = transByHash.get(next_hash.value);
            result.add(tran);
        }
        return result;
    }

    public static Double getBalance(String domain, String address) {
        Account account = Send.getAccount(domain, address);
        return account != null ? account.balance : null;
    }

    public static double getBalanceOrZero(String domain, String address) {
        Double balance = Send.getBalance(domain, address);
        return balance != null ? balance : 0.0;
    }

    protected String tokenSend(String scriptPath, String domain, String fromAddress, String toAddress, Double amount, String pass, String delegate) {
        String wrappedNetwork;
        String nextHash;
        if (fromAddress.equals(toAddress) && amount != 0.0) {
            Utils.error("from address and to address are the same");
        }
        if (amount - Utils.round(amount) != 0.0) {
            Utils.error("max amount decimals is 4");
        }
        if (amount < 0.0) {
            Utils.error("amount less than 0");
        }
        if (scriptPath == null) {
            Utils.error("script path null");
        }
        this.validateAddress(toAddress);
        String key = pass != null ? pass.split(":")[0] : null;
        String string = nextHash = pass != null ? pass.split(":")[1] : null;
        if (fromAddress.equals(GENESIS_ADDRESS) && Utils.isNotEmpty(key)) {
            Utils.error("when you create account key has to be empty");
        }
        if (fromAddress.equals(GENESIS_ADDRESS)) {
            this.validateDomain(domain);
            this.validateContract(delegate);
            if (Send.getAccount(domain, GENESIS_ADDRESS) == null) {
                if (amount == 0.0) {
                    Utils.error("when you create token amount has to be more than 0");
                }
                Account owner = new Account();
                owner.domain = domain;
                owner.address = GENESIS_ADDRESS;
                owner.prev_key = "";
                owner.next_hash = "";
                owner.balance = amount;
                owner.delegate = "mfm-token/send";
                this.setAccountCached(owner);
                if (amount > 0.0) {
                    this.setToken(new Token(domain, amount, delegate, toAddress));
                    this.trackTotal(APP, "tokens_count");
                }
            }
            if (Send.getAccount(domain, toAddress) == null) {
                Account to = new Account();
                to.domain = domain;
                to.address = toAddress;
                to.prev_key = "";
                to.next_hash = nextHash;
                to.balance = 0.0;
                to.delegate = delegate;
                this.setAccountCached(to);
            } else {
                Utils.error("account exists");
            }
        } else {
            this.validateAddress(fromAddress);
        }
        Account from = this.getAccountChanced(domain, fromAddress);
        Account to = this.getAccountChanced(domain, toAddress);
        if (from == null) {
            Utils.error("sender does not exist");
        }
        if (from.balance < amount) {
            Utils.error("balance is not enough");
        }
        if (to == null) {
            Utils.error("receiver does not exist");
        }
        if (from.delegate != null) {
            if (!from.address.equals(GENESIS_ADDRESS) && !from.delegate.equals(scriptPath)) {
                Utils.error("only delegated script can use account");
            }
        } else if (!from.next_hash.equals(Utils.hash(key))) {
            Utils.error("access denied");
        }
        String prevHash = from.next_hash;
        from.prev_key = key;
        from.next_hash = nextHash;
        from.balance = Utils.round(from.balance - amount);
        this.setAccountCached(from);
        if (!fromAddress.equals(toAddress)) {
            to.balance = Utils.round(to.balance + amount);
            this.setAccountCached(to);
        }
        if ((wrappedNetwork = this.getString("n")) != null) {
            Token token = Send.getToken(domain);
            if (fromAddress.equals(token.address)) {
                this.track(APP, wrappedNetwork, from.balance);
            }
            if (toAddress.equals(token.address)) {
                this.track(APP, wrappedNetwork, to.balance);
            }
        }
        this.setTran(new Transaction(domain, fromAddress, toAddress, amount, key, nextHash, prevHash, delegate, this.time()));
        return nextHash;
    }

    public void regAccount(String scriptPath, String domain, String address, String password, String delegate) {
        if (Send.getAccount(domain, address) == null) {
            this.tokenSend(scriptPath, domain, GENESIS_ADDRESS, address, 0.0, Send.tokenStartPass(domain, address, password), delegate);
        }
    }

    public void changePass(String scriptPath, String domain, String address, String pass) {
        this.tokenSend(scriptPath, domain, address, address, 0.0, pass, null);
    }

    @Override
    public void commit() {
        this.commitTrans();
        this.commitAccounts();
        this.commitTokens();
        super.commit();
        this.depositSuccess();
    }

    public void commitTokens() {
        for (Token token : this.tokensNew) {
            if (token.created == 0L) {
                token.created = this.time();
                if (token.domain.equals("usdt")) {
                    token.price = 1.0;
                    token.price24 = 0.0;
                }
                tokensSearch.put(token.domain, token.domain);
                System.out.println("token created " + token.domain);
            }
            tokensByDomain.put(token.domain, token);
            topMining.add(token);
        }
        this.tokensNew.clear();
    }

    public void commitTrans() {
        try {
            if (this.transactionsNew.size() > 0) {
                this.getRequired("domain");
            }
            Collections.reverse(this.transactionsNew);
            for (Transaction tran : this.transactionsNew) {
                transByHash.put(tran.next_hash, tran);
            }
            for (Transaction tran : this.transactionsNew) {
                fromToTransByDomain.addLast(tran.domain + tran.from + tran.to, tran.next_hash);
                userTrans.addLast(tran.from, tran.next_hash);
                userTrans.addLast(tran.to, tran.next_hash);
                WssServer.broadcast("account:" + tran.from, tran);
                WssServer.broadcast("account:" + tran.to, tran);
                WssServer.broadcast("transactions", tran);
                if (tran.from.equals(GENESIS_ADDRESS)) continue;
                this.trackTotal(APP, tran.domain + "_trans");
            }
            this.trackTotal(APP, "trans_count", this.transactionsNew.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commitAccounts() {
        for (Account account : this.accountsNew.values()) {
            if (!accounts.containsKey(account.domain + account.address) && !account.address.equals(GENESIS_ADDRESS)) {
                this.trackTotal(APP, account.domain + "_accounts");
                this.trackTotal(APP, "accounts_count");
                userDomains.addLast(account.address, account.domain);
            }
            accounts.put(account.domain + account.address, account);
            topAccounts.put(account.domain, account);
        }
        this.accountsNew.clear();
    }

    private void depositSuccess() {
        if (this.transactionsNew.size() > 0) {
            Map<String, Object> fullParams = this.getBodyAndQueryParams();
            String paramsJson = Utils.gson.toJson(fullParams);
            Utils.appendFile(REQUESTS_ACTIVE, paramsJson + ",");
            if (Node.isStarted) {
                WssServer.broadcast("requests", fullParams);
                if (Utils.isNotEmpty(Node.masterNode) && !Node.masterNode.equals("localhost")) {
                    Request.postAsync(Node.masterNode + "/" + this.scriptPath, fullParams);
                }
                for (Transaction tran : this.transactionsNew) {
                    for (DepositListener depositListener : depositListeners) {
                        try {
                            depositListener.run(tran);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            for (Transaction tran : this.transactionsNew) {
                for (DepositListener depositListener : loaderListeners) {
                    try {
                        depositListener.run(tran);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.transactionsNew.clear();
        }
    }

    public static void request(String domain, String from, String to, double amount, String pass, String delegate) {
        Send.request("mfm-token/send", domain, from, to, amount, pass, delegate);
    }

    public static void request(String contract, String domain, String from, String to, double amount, String pass, String delegate) {
        new Send().run(contract, Request.map("domain", domain, "from", from, "to", to, "pass", pass, "amount", "" + amount, "delegate", delegate == null ? "" : delegate));
    }

    public static void regAccount(String domain, String address, String password) {
        Send.regAccount(domain, address, password, null);
    }

    public static void regAccount(String domain, String address, String password, String delegate) {
        if (Send.getAccount(domain, address) == null) {
            Send.request(domain, GENESIS_ADDRESS, address, 0.0, Send.tokenStartPass(domain, address, password), delegate);
        }
    }

    public static void regToken(String domain, String address, String password, double amount, String delegate) {
        Send.request(domain, GENESIS_ADDRESS, address, amount, Send.tokenStartPass(domain, address, password), delegate);
    }

    static {
        if (Node.isDebugMode) {
            Utils.deleteDirRecursively("db-tokens");
        }
        transByHash = new BigMap<Transaction>(APP, "transByHash", Transaction.class);
        tokensByDomain = new BigMap<Token>(APP, "tokensByDomain", Token.class);
        accounts = new BigMap<Account>(APP, "accounts", Account.class);
        topAccounts = new MultiTop<Account>(APP, "accounts", accounts, Comparator.comparingDouble(t -> t.balance), 10);
        tokensSearch = new SearchIndex(APP, "tokensSearch");
        userDomains = new BigChain64(APP, "userDomains");
        userTrans = new BigChain64(APP, "userTrans");
        fromToTransByDomain = new BigChain64(APP, "fromToTransByDomain");
        topMining = new Top<Token>(APP, "topMining3", tokensByDomain, Comparator.comparingLong(t -> t.difficulty), 10);
        depositListeners = new ArrayList<DepositListener>();
        loaderListeners = new ArrayList<DepositListener>();
    }
}

