/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.contract;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.gdb.BigChain;
import org.vavilon.gdb.BigChain64;
import org.vavilon.servers.WssServer;
import org.vavilon.token.base.Send;
import org.vavilon.token.contract.EpochFinish;
import org.vavilon.token.contract.model.Data;
import org.vavilon.token.contract.model.PathValue;
import org.vavilon.token.utils.Utils;

public abstract class Contract
extends Send {
    public static final double DATA_GAS_FOR_ROW = 1.0E-4;
    public static final String GAS_DOMAIN = "usdt";
    public static final String VAVILON = "vavilon";
    public static final BigChain64 dataAll = new BigChain64("tokens", "allData");
    public static final BigChain<PathValue> dataByTran = new BigChain<PathValue>("tokens", "dataByTran", PathValue.class);
    public List<Data> dataNew = new ArrayList<Data>();

    public void dataSet(String path, String value) {
        if (path.length() > 64) {
            Utils.error("Path too long");
        }
        if (value.length() > 64) {
            Utils.error("Value too long");
        }
        Data data = new Data();
        data.path = path;
        data.value = value;
        this.dataNew.add(data);
    }

    public static Double dataGetDouble(String path) {
        String response = Contract.dataGet(path);
        if (response == null) {
            return null;
        }
        return Double.parseDouble(response);
    }

    public static String dataGet(String path) {
        return dataAll.getLastString(path);
    }

    public static Long dataGetLong(String path, Long defaultValue) {
        String data = Contract.dataGet(path);
        return data == null ? defaultValue : Long.parseLong(data);
    }

    public static Long dataGetLong(String path) {
        String data = Contract.dataGet(path);
        return data == null ? null : Long.valueOf(Long.parseLong(data));
    }

    public static List<String> dataHistory(String path, long size) {
        return dataAll.getStringsFromEnd(path, size);
    }

    public static List<Long> dataHistoryLong(String path, int size) {
        List<String> strings = Contract.dataHistory(path, size);
        ArrayList<Long> response = new ArrayList<Long>();
        for (String string : strings) {
            response.add(Long.parseLong(string));
        }
        return response;
    }

    @Override
    public void commit() {
        double gas_commission = Utils.round(1.0E-4 * (double)this.dataNew.size());
        if (gas_commission > 0.0) {
            String gas_address = this.getAddress("gas_address");
            String gas_pass = this.getRequired("gas_pass");
            if (Contract.getBalanceOrZero(GAS_DOMAIN, gas_address) < gas_commission) {
                Utils.error("Not enough gas");
            }
            this.regAccount(this.scriptPath, GAS_DOMAIN, EpochFinish.GAS_ADDRESS, EpochFinish.GAS_PASSWORD, null);
            String next_hash = this.tokenSend(this.scriptPath, GAS_DOMAIN, gas_address, EpochFinish.GAS_ADDRESS, gas_commission, gas_pass, null);
            super.commit();
            for (Data data : this.dataNew) {
                dataAll.addLast(data.path, data.value);
                dataByTran.addLast(next_hash, new PathValue(data.path, data.value, next_hash));
                WssServer.broadcast("data", Utils.toMap(data));
            }
            this.dataNew.clear();
        } else {
            super.commit();
        }
    }
}

