/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.contract;

import java.util.List;
import org.vavilon.charts.Chart;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.contract.EpochFinish;
import org.vavilon.token.utils.Utils;

public class Epoch
extends Get {
    @Override
    public Response get() {
        Transaction lastEpoch;
        String address = this.getAddressNotRequired("address");
        Response response = new Response();
        response.reward = lastEpoch = EpochFinish.getEpochTran();
        response.epoch_number = Chart.getChartLastValue("tokens", "epoch_number");
        response.all_rewards = Chart.getChartLastValue("tokens", "all_rewards");
        response.participants = Send.getAccount("vavilon", lastEpoch.to);
        response.gas = Send.getAccount("usdt", EpochFinish.GAS_ADDRESS);
        if (Utils.isNotEmpty(address)) {
            response.trans = Send.getTrans("vavilon", address, lastEpoch.to, 0L, 10L);
        }
        return response;
    }

    public class Response
    extends Get.Response {
        public double epoch_number;
        public Transaction reward;
        public List<Transaction> trans;
        public Account participants;
        public double all_rewards;
        public Account gas;
    }
}

