/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.contract;

import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.utils.Format;
import org.vavilon.charts.Chart;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class EpochFinish
extends Send {
    public static final String GAS_SEED = "nation finger unable fade exist visa arch awake anchor surround paddle rifle";
    public static final String GAS_PASSWORD = Utils.hash("nation finger unable fade exist visa arch awake anchor surround paddle rifle");
    public static final String GAS_ADDRESS = EpochFinish.hashAddress(GAS_PASSWORD);

    public static Transaction getEpochTran() {
        Transaction epochTran = null;
        Transaction result = null;
        String prevKey = null;
        String nextHash = null;
        while (nextHash == null || epochTran != null) {
            result = epochTran;
            String[] pass = EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD, prevKey).split(":");
            prevKey = pass[0];
            nextHash = pass[1];
            epochTran = (Transaction)transByHash.get(nextHash);
        }
        return result;
    }

    @Override
    public void run() {
        Double epoch_vavilon_stop_balance = this.getDoubleRequired("epoch_vavilon_stop_balance");
        Transaction epochTran = EpochFinish.getEpochTran();
        Double nextEpochReward = Utils.round((epochTran == null ? 10.0 : epochTran.amount) * 1.01);
        String epochAddress = epochTran == null ? null : epochTran.to;
        double gasBalance = EpochFinish.getBalanceOrZero("usdt", GAS_ADDRESS);
        double participantsBalance = EpochFinish.getBalanceOrZero("vavilon", epochAddress);
        if (epochAddress != null && participantsBalance == 0.0) {
            Utils.error("epoch vavilon balance is zero");
        }
        if (gasBalance >= nextEpochReward && participantsBalance == epoch_vavilon_stop_balance) {
            if (epochTran != null) {
                if (participantsBalance > 0.0) {
                    for (String next_hash : userTrans.getStringsFromEnd(epochAddress, 1000L)) {
                        Transaction tran = (Transaction)transByHash.get(next_hash);
                        if (tran.amount == 0.0 || !tran.domain.equals("vavilon")) continue;
                        double rewardForAddress = Utils.roundDown(epochTran.amount * (tran.amount / participantsBalance));
                        this.tokenSend(this.scriptPath, "usdt", epochAddress, tran.from, rewardForAddress, EpochFinish.tokenPass("usdt", epochAddress, GAS_PASSWORD), null);
                        this.tokenSend(this.scriptPath, "vavilon", epochAddress, tran.from, tran.amount, EpochFinish.tokenPass("vavilon", epochAddress, GAS_PASSWORD), null);
                    }
                }
                Account epochGas = this.getAccountChanced("usdt", epochAddress);
                this.trackTotal("tokens", "all_rewards", epochTran.amount - epochGas.balance);
                this.trackTotal("tokens", "epoch_number", 1.0);
                if (epochGas.balance > 0.0) {
                    this.tokenSend(this.scriptPath, "usdt", epochAddress, GAS_ADDRESS, epochGas.balance, this.tokenPassCached("usdt", epochAddress, GAS_PASSWORD), null);
                }
            }
            String nextEpochAddress = EpochFinish.address(EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD, epochTran == null ? null : epochTran.prev_key).split(":")[1]);
            this.regAccount(this.scriptPath, "usdt", nextEpochAddress, GAS_PASSWORD, "mfm-contract/epoch_finish");
            this.regAccount(this.scriptPath, "vavilon", nextEpochAddress, GAS_PASSWORD, "mfm-contract/epoch_finish");
            this.tokenSend(this.scriptPath, "usdt", GAS_ADDRESS, nextEpochAddress, nextEpochReward, EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD), null);
            if (epochTran != null) {
                try {
                    Telegram.sendToTokenChannel("vavilon", "epoch_finished", Request.map("epoch_number", Format.formatAmount(Chart.getChartLastValue("tokens", "epoch_number"), null, 0), "duration", Format.formatTime(this.time() - epochTran.time, Telegram.getChannelLanguage("vavilon")), "reward", Format.formatAmount(epochTran.amount, "usdt", 2), "total_reward", Format.formatAmount(Chart.getChartLastValue("tokens", "all_rewards") + epochTran.amount, "usdt", 0), "tokens_count", Format.formatAmount(Chart.getChartLastValue("tokens", "tokens_count"), null, 0), "accounts_count", Format.formatAmount(Chart.getChartLastValue("tokens", "accounts_count"), null, 0), "trans_count", Format.formatAmount(Chart.getChartLastValue("tokens", "trans_count"), null, 0), "mining_difficulty", Format.formatAmount(Chart.getChartLastValue("tokens", "vavilon_difficulty"), null, 0)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            Utils.error("epoch is not finished");
        }
    }
}

