/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.utils;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Request {
    public static Gson gson = new Gson();

    public static String post(String url) throws Exception {
        return Request.post(url, null);
    }

    public static String post(String url, Map<String, Object> params) throws Exception {
        return Request.post(url, params, null);
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return Request.getString("POST", url, params, headers);
    }

    public static String get(String url) throws Exception {
        return Request.get(url, null);
    }

    public static String get(String url, Map<String, Object> params) throws Exception {
        return Request.get(url, params, null);
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        String queryString = Request.buildQuery(params);
        String fullUrl = url + (queryString.isEmpty() ? "" : "?" + queryString);
        return Request.getString("GET", fullUrl, null, headers);
    }

    private static String buildQuery(Map<String, Object> params) throws Exception {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!first) {
                sb.append("&");
            } else {
                first = false;
            }
            sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            sb.append("=");
            sb.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
        }
        return sb.toString();
    }

    public static void postAsync(String url) {
        Request.postAsync(url, null);
    }

    public static void postAsync(String url, Map<String, Object> params) {
        Request.postAsync(url, params, null);
    }

    public static void postAsync(String url, Map<String, Object> params, Success success) {
        Request.postAsync(url, params, success, message -> System.out.println("error: " + message));
    }

    public static void postAsync(String url, Map<String, Object> params, Success success, Error error) {
        Request.postAsync(url, params, success, error, null);
    }

    public static void postAsync(String url, Map<String, Object> params, Success success, Error error, Map<String, String> headers) {
        Request.getStringAsync("POST", url, params, success, error, headers);
    }

    public static void getAsync(String url) {
        Request.getAsync(url, null);
    }

    public static void getAsync(String url, Map<String, Object> params) {
        Request.getAsync(url, params, null);
    }

    public static void getAsync(String url, Map<String, Object> params, Success success) {
        Request.getAsync(url, params, success, null);
    }

    public static void getAsync(String url, Map<String, Object> params, Success success, Error error) {
        Request.getAsync(url, params, success, error, null);
    }

    public static void getAsync(String url, Map<String, Object> params, Success success, Error error, Map<String, String> headers) {
        Request.getStringAsync("GET", url, params, success, error, headers);
    }

    public static void getStringAsync(String method, String url, Map<String, Object> params, Success success, Error error, Map<String, String> headers) {
        new Thread(() -> {
            try {
                byte[] data = Request.getBytes(method, url, params, headers);
                try {
                    success.run(new String(data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                error.run(e.getMessage());
            }
        }).start();
    }

    private static String getString(String method, String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        return new String(Request.getBytes(method, url, params, headers));
    }

    public static byte[] getBytes(String url) throws Exception {
        return Request.getBytes("GET", url, null, null);
    }

    private static byte[] getBytes(String method, String url, Map<String, Object> params, Map<String, String> headers) throws Exception {
        int responseCode;
        System.out.println(url);
        if (url == null) {
            return null;
        }
        if (!url.contains("://")) {
            url = url.contains("localhost") ? "http://" + url : "https://" + url;
        }
        if ("GET".equals(method) && params != null && !params.isEmpty()) {
            StringBuilder urlBuilder = new StringBuilder(url);
            urlBuilder.append(url.contains("?") ? "&" : "?");
            for (Map.Entry entry : params.entrySet()) {
                urlBuilder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF-8")).append("&");
            }
            url = urlBuilder.substring(0, urlBuilder.length() - 1);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method);
        conn.setConnectTimeout(3000);
        if (headers != null) {
            for (String string : headers.keySet()) {
                conn.setRequestProperty(string, headers.get(string));
            }
        }
        if ("POST".equals(method) && params != null) {
            conn.setDoOutput(true);
            if (params != null) {
                String paramsStr = gson.toJson(params);
                byte[] byArray = paramsStr.getBytes("UTF-8");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Content-Length", "" + byArray.length);
                conn.getOutputStream().write(byArray, 0, byArray.length);
                System.out.println(paramsStr);
            }
        }
        if ((responseCode = conn.getResponseCode()) == 200) {
            return Request.convertToBytes(conn.getInputStream());
        }
        String string = new String(Request.convertToBytes(conn.getErrorStream()));
        throw new RuntimeException(string);
    }

    public static Map<String, Object> map(Object ... params) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of parameters");
        }
        for (int i = 0; i < params.length; i += 2) {
            if (!(params[i] instanceof String)) {
                throw new IllegalArgumentException("Keys must be String");
            }
            paramMap.put((String)params[i], params[i + 1]);
        }
        return paramMap;
    }

    public static Map<String, String> stringMap(Object ... params) {
        Map<String, Object> originalMap = Request.map(params);
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        Iterator<String> iterator = originalMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            Object value = originalMap.get(key = iterator.next());
            stringMap.put(key, value != null ? value.toString() : null);
        }
        return stringMap;
    }

    public static byte[] convertToBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static Map<String, String> parseQuery(String query) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (query != null) {
            String[] pairs;
            int questionMarkIndex = query.lastIndexOf(63);
            if (questionMarkIndex != -1 && questionMarkIndex < query.length() - 1) {
                query = query.substring(questionMarkIndex + 1);
            }
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                params.put(keyValue[0], keyValue[1]);
            }
        }
        return params;
    }

    public static interface Success {
        public void run(String var1);
    }

    public static interface Error {
        public void run(String var1);
    }
}

