/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.utils;

import java.util.Map;
import org.vavilon.token.utils.Utils;

public class Settings {
    public static final String FILENAME = "settings.ini";

    public static String get(String group, String key) {
        return Settings.get(group, key, null);
    }

    public static String get(String group, String key, String def) {
        key = key.toUpperCase();
        Map<String, String> map = Utils.readFileIni(FILENAME, (group = group.toUpperCase()) + "_", "=", " ");
        String value = map.get(key);
        if (value == null) {
            Utils.appendFile(FILENAME, "\n" + group + "_" + key + "=");
        }
        if (Utils.isEmpty(value) && Utils.isEmpty(def)) {
            try {
                throw new RuntimeException(group + "_" + key + " has to be set in " + FILENAME);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return Utils.isEmpty(value) ? def : value;
    }

    public static Long getLong(String group, String key) {
        return Settings.getLong(group, key, null);
    }

    public static Long getLong(String group, String key, Long def) {
        try {
            String str = Settings.get(group, key);
            return str == null ? def : Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Integer getInteger(String group, String key) {
        return Settings.getInteger(group, key, null);
    }

    public static Integer getInteger(String group, String key, Integer def) {
        try {
            String str = Settings.get(group, key);
            return str == null ? def : Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double getDouble(String group, String key) {
        return Settings.getDouble(group, key, null);
    }

    public static Double getDouble(String group, String key, Double def) {
        try {
            String str = Settings.get(group, key);
            return str == null ? def : Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

