/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.EncryptedData;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterException;
import org.bitcoinj.crypto.LinuxSecureRandom;
import org.bitcoinj.wallet.Protos;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCrypterScrypt
implements KeyCrypter {
    private static final Logger log = LoggerFactory.getLogger(KeyCrypterScrypt.class);
    public static final int KEY_LENGTH = 32;
    public static final int BLOCK_LENGTH = 16;
    public static final int SALT_LENGTH = 8;
    private static final SecureRandom secureRandom;
    private final Protos.ScryptParameters scryptParameters;

    public static byte[] randomSalt() {
        byte[] salt = new byte[8];
        secureRandom.nextBytes(salt);
        return salt;
    }

    public KeyCrypterScrypt() {
        Protos.ScryptParameters.Builder scryptParametersBuilder = Protos.ScryptParameters.newBuilder().setSalt(ByteString.copyFrom((byte[])KeyCrypterScrypt.randomSalt()));
        this.scryptParameters = scryptParametersBuilder.build();
    }

    public KeyCrypterScrypt(int iterations) {
        Protos.ScryptParameters.Builder scryptParametersBuilder = Protos.ScryptParameters.newBuilder().setSalt(ByteString.copyFrom((byte[])KeyCrypterScrypt.randomSalt())).setN(iterations);
        this.scryptParameters = scryptParametersBuilder.build();
    }

    public KeyCrypterScrypt(Protos.ScryptParameters scryptParameters) {
        this.scryptParameters = (Protos.ScryptParameters)Preconditions.checkNotNull((Object)scryptParameters);
        if (scryptParameters.getSalt() == null || scryptParameters.getSalt().toByteArray() == null || scryptParameters.getSalt().toByteArray().length == 0) {
            log.warn("You are using a ScryptParameters with no salt. Your encryption may be vulnerable to a dictionary attack.");
        }
    }

    @Override
    public KeyParameter deriveKey(CharSequence password) throws KeyCrypterException {
        byte[] passwordBytes = null;
        try {
            passwordBytes = KeyCrypterScrypt.convertToByteArray(password);
            byte[] salt = new byte[]{};
            if (this.scryptParameters.getSalt() != null) {
                salt = this.scryptParameters.getSalt().toByteArray();
            } else {
                log.warn("You are using a ScryptParameters with no salt. Your encryption may be vulnerable to a dictionary attack.");
            }
            Stopwatch watch = Stopwatch.createStarted();
            byte[] keyBytes = SCrypt.generate((byte[])passwordBytes, (byte[])salt, (int)((int)this.scryptParameters.getN()), (int)this.scryptParameters.getR(), (int)this.scryptParameters.getP(), (int)32);
            watch.stop();
            log.info("Deriving key took {} for {}.", (Object)watch, (Object)this.scryptParametersString());
            KeyParameter keyParameter = new KeyParameter(keyBytes);
            return keyParameter;
        }
        catch (Exception e) {
            throw new KeyCrypterException("Could not generate key from password and salt.", e);
        }
        finally {
            if (passwordBytes != null) {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }

    @Override
    public EncryptedData encrypt(byte[] plainBytes, KeyParameter aesKey) throws KeyCrypterException {
        Preconditions.checkNotNull((Object)plainBytes);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            byte[] iv = new byte[16];
            secureRandom.nextBytes(iv);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)aesKey, iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(true, (CipherParameters)keyWithIv);
            byte[] encryptedBytes = new byte[cipher.getOutputSize(plainBytes.length)];
            int length1 = cipher.processBytes(plainBytes, 0, plainBytes.length, encryptedBytes, 0);
            int length2 = cipher.doFinal(encryptedBytes, length1);
            return new EncryptedData(iv, Arrays.copyOf(encryptedBytes, length1 + length2));
        }
        catch (Exception e) {
            throw new KeyCrypterException("Could not encrypt bytes.", e);
        }
    }

    @Override
    public byte[] decrypt(EncryptedData dataToDecrypt, KeyParameter aesKey) throws KeyCrypterException {
        Preconditions.checkNotNull((Object)dataToDecrypt);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey.getKey()), dataToDecrypt.initialisationVector);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(false, (CipherParameters)keyWithIv);
            byte[] cipherBytes = dataToDecrypt.encryptedBytes;
            byte[] decryptedBytes = new byte[cipher.getOutputSize(cipherBytes.length)];
            int length1 = cipher.processBytes(cipherBytes, 0, cipherBytes.length, decryptedBytes, 0);
            int length2 = cipher.doFinal(decryptedBytes, length1);
            return Arrays.copyOf(decryptedBytes, length1 + length2);
        }
        catch (InvalidCipherTextException e) {
            throw new KeyCrypterException.InvalidCipherText("Could not decrypt bytes", e);
        }
        catch (RuntimeException e) {
            throw new KeyCrypterException("Could not decrypt bytes", e);
        }
    }

    private static byte[] convertToByteArray(CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        byte[] byteArray = new byte[charSequence.length() << 1];
        for (int i = 0; i < charSequence.length(); ++i) {
            int bytePosition = i << 1;
            byteArray[bytePosition] = (byte)((charSequence.charAt(i) & 0xFF00) >> 8);
            byteArray[bytePosition + 1] = (byte)(charSequence.charAt(i) & 0xFF);
        }
        return byteArray;
    }

    public Protos.ScryptParameters getScryptParameters() {
        return this.scryptParameters;
    }

    @Override
    public Protos.Wallet.EncryptionType getUnderstoodEncryptionType() {
        return Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES;
    }

    public String toString() {
        return "AES-256-CBC, Scrypt (" + this.scryptParametersString() + ")";
    }

    private String scryptParametersString() {
        return "N=" + this.scryptParameters.getN() + ", r=" + this.scryptParameters.getR() + ", p=" + this.scryptParameters.getP();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scryptParameters});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equal((Object)this.scryptParameters, (Object)((KeyCrypterScrypt)o).scryptParameters);
    }

    static {
        if (Utils.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        secureRandom = new SecureRandom();
    }
}

