/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.ConnectionHandler;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioClientManager
extends AbstractExecutionThreadService
implements ClientConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(NioClientManager.class);
    private final Selector selector;
    final Queue<PendingConnect> newConnectionChannels = new LinkedBlockingQueue<PendingConnect>();
    private final Set<ConnectionHandler> connectedHandlers = Collections.synchronizedSet(new HashSet());

    private void handleKey(SelectionKey key) throws IOException {
        block5: {
            if (key.isValid() && key.isConnectable()) {
                PendingConnect data = (PendingConnect)key.attachment();
                StreamConnection connection = data.connection;
                SocketChannel sc = (SocketChannel)key.channel();
                ConnectionHandler handler = new ConnectionHandler(connection, key, this.connectedHandlers);
                try {
                    if (sc.finishConnect()) {
                        log.info("Connected to {}", (Object)sc.socket().getRemoteSocketAddress());
                        key.interestOps((key.interestOps() | 1) & 0xFFFFFFF7).attach(handler);
                        connection.connectionOpened();
                        data.future.set((Object)data.address);
                        break block5;
                    }
                    log.warn("Failed to connect to {}", (Object)sc.socket().getRemoteSocketAddress());
                    handler.closeConnection();
                    data.future.setException((Throwable)new ConnectException("Unknown reason"));
                    data.future = null;
                }
                catch (Exception e) {
                    Throwable cause = Throwables.getRootCause((Throwable)e);
                    log.warn("Failed to connect with exception: {}: {}", new Object[]{cause.getClass().getName(), cause.getMessage(), e});
                    handler.closeConnection();
                    data.future.setException(cause);
                    data.future = null;
                }
            } else {
                ConnectionHandler.handleKey(key);
            }
        }
    }

    public NioClientManager() {
        try {
            this.selector = SelectorProvider.provider().openSelector();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block24: {
            Thread.currentThread().setPriority(1);
            while (this.isRunning()) {
                Object conn;
                while ((conn = this.newConnectionChannels.poll()) != null) {
                    try {
                        SelectionKey key = ((PendingConnect)conn).sc.register(this.selector, 8);
                        key.attach(conn);
                    }
                    catch (ClosedChannelException e) {
                        log.warn("SocketChannel was closed before it could be registered");
                    }
                }
                this.selector.select();
                Iterator<SelectionKey> keyIterator = this.selector.selectedKeys().iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    keyIterator.remove();
                    this.handleKey(key);
                }
            }
            for (SelectionKey key : this.selector.keys()) {
                try {
                    key.channel().close();
                }
                catch (IOException e) {
                    log.warn("Error closing channel", (Throwable)e);
                }
                key.cancel();
                if (!(key.attachment() instanceof ConnectionHandler)) continue;
                ConnectionHandler.handleKey(key);
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.warn("Error closing client manager selector", (Throwable)e);
            }
            break block24;
            catch (Exception e) {
                log.warn("Error trying to open/read from connection: ", (Throwable)e);
                break block24;
            }
            finally {
                for (SelectionKey key : this.selector.keys()) {
                    try {
                        key.channel().close();
                    }
                    catch (IOException e) {
                        log.warn("Error closing channel", (Throwable)e);
                    }
                    key.cancel();
                    if (!(key.attachment() instanceof ConnectionHandler)) continue;
                    ConnectionHandler.handleKey(key);
                }
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    log.warn("Error closing client manager selector", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ListenableFuture<SocketAddress> openConnection(SocketAddress serverAddress, StreamConnection connection) {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        try {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            sc.connect(serverAddress);
            PendingConnect data = new PendingConnect(sc, connection, serverAddress);
            this.newConnectionChannels.offer(data);
            this.selector.wakeup();
            return data.future;
        }
        catch (Throwable e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public void triggerShutdown() {
        this.selector.wakeup();
    }

    @Override
    public int getConnectedClientCount() {
        return this.connectedHandlers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnections(int n) {
        while (n-- > 0) {
            ConnectionHandler handler;
            Set<ConnectionHandler> set = this.connectedHandlers;
            synchronized (set) {
                handler = this.connectedHandlers.iterator().next();
            }
            if (handler == null) continue;
            handler.closeConnection();
        }
    }

    protected Executor executor() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                new ContextPropagatingThreadFactory("NioClientManager").newThread(command).start();
            }
        };
    }

    class PendingConnect {
        SocketChannel sc;
        StreamConnection connection;
        SocketAddress address;
        SettableFuture<SocketAddress> future = SettableFuture.create();

        PendingConnect(SocketChannel sc, StreamConnection connection, SocketAddress address) {
            this.sc = sc;
            this.connection = connection;
            this.address = address;
        }
    }
}

