/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.protocols.channels.PaymentChannelServerState;
import org.bitcoinj.protocols.channels.PaymentChannelV1ServerState;
import org.bitcoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChannelV2ServerState
extends PaymentChannelServerState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelV1ServerState.class);
    private Coin feePaidForPayment;
    protected ECKey clientKey;
    final SettableFuture<Transaction> closedFuture = SettableFuture.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PaymentChannelV2ServerState(StoredServerChannel storedServerChannel, Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        super(storedServerChannel, wallet, broadcaster);
        StoredServerChannel storedServerChannel2 = storedServerChannel;
        synchronized (storedServerChannel2) {
            this.clientKey = storedServerChannel.clientKey;
            this.stateMachine.transition(PaymentChannelServerState.State.READY);
        }
    }

    public PaymentChannelV2ServerState(TransactionBroadcaster broadcaster, Wallet wallet, ECKey serverKey, long minExpireTime) {
        super(broadcaster, wallet, serverKey, minExpireTime);
        this.stateMachine.transition(PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT);
    }

    @Override
    public Multimap<PaymentChannelServerState.State, PaymentChannelServerState.State> getStateTransitions() {
        ListMultimap result = MultimapBuilder.enumKeys(PaymentChannelServerState.State.class).arrayListValues().build();
        result.put((Object)PaymentChannelServerState.State.UNINITIALISED, (Object)PaymentChannelServerState.State.READY);
        result.put((Object)PaymentChannelServerState.State.UNINITIALISED, (Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT);
        result.put((Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT, (Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_ACCEPTANCE);
        result.put((Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_ACCEPTANCE, (Object)PaymentChannelServerState.State.READY);
        result.put((Object)PaymentChannelServerState.State.READY, (Object)PaymentChannelServerState.State.CLOSING);
        result.put((Object)PaymentChannelServerState.State.CLOSING, (Object)PaymentChannelServerState.State.CLOSED);
        for (PaymentChannelServerState.State state : PaymentChannelServerState.State.values()) {
            result.put((Object)state, (Object)PaymentChannelServerState.State.ERROR);
        }
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public TransactionOutput getClientOutput() {
        return null;
    }

    public void provideClientKey(byte[] clientKey) {
        this.clientKey = ECKey.fromPublicOnly(clientKey);
    }

    @Override
    public synchronized Coin getFeePaid() {
        this.stateMachine.checkState(new PaymentChannelServerState.State[]{PaymentChannelServerState.State.CLOSED, PaymentChannelServerState.State.CLOSING});
        return this.feePaidForPayment;
    }

    @Override
    protected Script getSignedScript() {
        return this.createP2SHRedeemScript();
    }

    @Override
    protected void verifyContract(Transaction contract) {
        super.verifyContract(contract);
        byte[] expected = this.getContractScript().getPubKeyHash();
        byte[] actual = Utils.sha256hash160(this.createP2SHRedeemScript().getProgram());
        if (!Arrays.equals(actual, expected)) {
            throw new VerificationException("P2SH hash didn't match required contract - contract should be a CLTV micropayment channel to client and server in that order.");
        }
    }

    @Override
    protected Script createOutputScript() {
        return ScriptBuilder.createP2SHOutputScript(this.createP2SHRedeemScript());
    }

    private Script createP2SHRedeemScript() {
        return ScriptBuilder.createCLTVPaymentChannelOutput(BigInteger.valueOf(this.getExpiryTime()), this.clientKey, this.serverKey);
    }

    @Override
    protected ECKey getClientKey() {
        return this.clientKey;
    }

    private void signP2SHInput(Transaction tx, Transaction.SigHash hashType, boolean anyoneCanPay, @Nullable KeyParameter userKey) {
        TransactionSignature signature = tx.calculateSignature(0, this.serverKey, userKey, this.createP2SHRedeemScript(), hashType, anyoneCanPay);
        byte[] mySig = signature.encodeToBitcoin();
        Script scriptSig = ScriptBuilder.createCLTVPaymentChannelP2SHInput(this.bestValueSignature, mySig, this.createP2SHRedeemScript());
        tx.getInput(0L).setScriptSig(scriptSig);
    }

    @Override
    public synchronized ListenableFuture<Transaction> close(@Nullable KeyParameter userKey) throws InsufficientMoneyException {
        if (this.storedServerChannel != null) {
            StoredServerChannel temp = this.storedServerChannel;
            this.storedServerChannel = null;
            StoredPaymentChannelServerStates channels = (StoredPaymentChannelServerStates)this.wallet.getExtensions().get(StoredPaymentChannelServerStates.EXTENSION_ID);
            channels.closeChannel(temp);
            if (this.getState().compareTo(PaymentChannelServerState.State.CLOSING) >= 0) {
                return this.closedFuture;
            }
        }
        if (this.getState().ordinal() < PaymentChannelServerState.State.READY.ordinal()) {
            log.error("Attempt to settle channel in state " + (Object)((Object)this.getState()));
            this.stateMachine.transition(PaymentChannelServerState.State.CLOSED);
            this.closedFuture.set(null);
            return this.closedFuture;
        }
        if (this.getState() != PaymentChannelServerState.State.READY) {
            log.warn("Failed attempt to settle a channel in state " + (Object)((Object)this.getState()));
            return this.closedFuture;
        }
        Transaction tx = null;
        try {
            SendRequest req = this.makeUnsignedChannelContract(this.bestValueToMe);
            tx = req.tx;
            this.signP2SHInput(tx, Transaction.SigHash.NONE, true, userKey);
            req.shuffleOutputs = false;
            req.missingSigsMode = Wallet.MissingSigsMode.USE_DUMMY_SIG;
            this.wallet.completeTx(req);
            this.feePaidForPayment = req.tx.getFee();
            log.info("Calculated fee is {}", (Object)this.feePaidForPayment);
            if (this.feePaidForPayment.compareTo(this.bestValueToMe) > 0) {
                String msg = String.format(Locale.US, "Had to pay more in fees (%s) than the channel was worth (%s)", this.feePaidForPayment, this.bestValueToMe);
                throw new InsufficientMoneyException(this.feePaidForPayment.subtract(this.bestValueToMe), msg);
            }
            this.signP2SHInput(tx, Transaction.SigHash.ALL, false, userKey);
            tx.verify();
            for (TransactionInput input : tx.getInputs()) {
                input.verify();
            }
        }
        catch (InsufficientMoneyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Could not verify self-built tx\nMULTISIG {}\nCLOSE {}", (Object)this.contract, tx != null ? tx : "");
            throw new RuntimeException(e);
        }
        this.stateMachine.transition(PaymentChannelServerState.State.CLOSING);
        log.info("Closing channel, broadcasting tx {}", (Object)tx);
        ListenableFuture<Transaction> future = this.broadcaster.broadcastTransaction(tx).future();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction transaction) {
                log.info("TX {} propagated, channel successfully closed.", (Object)transaction.getTxId());
                PaymentChannelV2ServerState.this.stateMachine.transition(PaymentChannelServerState.State.CLOSED);
                PaymentChannelV2ServerState.this.closedFuture.set((Object)transaction);
            }

            public void onFailure(Throwable throwable) {
                log.error("Failed to settle channel, could not broadcast: {}", throwable);
                PaymentChannelV2ServerState.this.stateMachine.transition(PaymentChannelServerState.State.ERROR);
                PaymentChannelV2ServerState.this.closedFuture.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return this.closedFuture;
    }
}

