/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.eclipse.jetty.session.infinispan.SessionDataMarshaller;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;

public class InfinispanSessionLegacyConverter {
    RemoteCacheManager _protoManager;
    RemoteCache<String, InfinispanSessionData> _protoCache;
    RemoteCacheManager _legacyManager = new RemoteCacheManager();
    RemoteCache<String, SessionData> _legacyCache;
    boolean _verbose = false;

    public InfinispanSessionLegacyConverter(String cacheName) throws Exception {
        this._legacyCache = this._legacyManager.getCache(cacheName);
        String host = System.getProperty("host", "127.0.0.1");
        this._verbose = Boolean.getBoolean("verbose");
        Properties properties = new Properties();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        ProtoStreamMarshaller protoStreamMarshaller = new ProtoStreamMarshaller();
        clientBuilder.withProperties(properties).addServer().host(host).marshaller((Marshaller)protoStreamMarshaller);
        this._protoManager = new RemoteCacheManager(clientBuilder.build());
        FileDescriptorSource fds = new FileDescriptorSource();
        fds.addProtoFiles(new String[]{"/session.proto"});
        SerializationContext serCtx = protoStreamMarshaller.getSerializationContext();
        serCtx.registerProtoFiles(fds);
        serCtx.registerMarshaller((BaseMarshaller)new SessionDataMarshaller());
        this._protoCache = this._protoManager.getCache(cacheName);
    }

    public void convert() {
        long conversions = 0L;
        List keys = null;
        try {
            keys = this._legacyCache.keySet().stream().collect(Collectors.toList());
        }
        catch (Exception e) {
            System.err.println("Error listing legacy sessions, assuming previously converted. Run again using 'check' argument to verify conversion");
            if (this._verbose) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        for (String s : keys) {
            SessionData data = null;
            try {
                data = (SessionData)this._legacyCache.get((Object)s);
            }
            catch (Exception e) {
                System.err.println("Read of session " + s + " failed. Assuming session already converted and skipping.");
                if (!this._verbose) continue;
                e.printStackTrace();
                continue;
            }
            if (data != null) {
                try {
                    this._legacyCache.remove((Object)s);
                }
                catch (Exception e) {
                    System.err.println("Remove legacy session failed for " + s + " skipping conversion.");
                    if (!this._verbose) continue;
                    e.printStackTrace();
                    continue;
                }
                try {
                    InfinispanSessionData isd = new InfinispanSessionData(data.getId(), data.getContextPath(), data.getVhost(), data.getCreated(), data.getAccessed(), data.getLastAccessed(), data.getMaxInactiveMs());
                    isd.putAllAttributes(data.getAllAttributes());
                    isd.setExpiry(data.getExpiry());
                    isd.setCookieSet(data.getCookieSet());
                    isd.setLastSaved(data.getLastSaved());
                    isd.setLastNode(data.getLastNode());
                    this._protoCache.put((Object)s, (Object)isd);
                    System.err.println("Converted " + s);
                    ++conversions;
                }
                catch (Exception e) {
                    if (this._verbose) {
                        e.printStackTrace();
                    }
                    System.err.println("Conversion failed for " + s + " re-instating legacy session.");
                    try {
                        this._legacyCache.put((Object)s, (Object)data);
                    }
                    catch (Exception x) {
                        System.err.println("FAILED REINSTATING SESSION " + s + ". ABORTING.");
                        x.printStackTrace();
                        System.exit(1);
                    }
                }
                continue;
            }
            System.err.println("Unreadable legacy session " + s);
        }
        System.err.println("Total sessions converted: " + conversions);
    }

    public void checkConverted() {
        List keys = null;
        try {
            keys = this._protoCache.keySet().stream().collect(Collectors.toList());
        }
        catch (Exception e) {
            System.err.println("Unable to read converted sessions, assuming still in legacy format. Run again without 'check' option to convert.");
            e.printStackTrace();
            System.exit(1);
        }
        for (String s : keys) {
            InfinispanSessionData converted = (InfinispanSessionData)((Object)this._protoCache.get((Object)s));
            if (converted != null) {
                System.err.println("OK: " + String.valueOf((Object)converted));
                converted.getKeys().stream().forEach(ss -> System.err.println(ss + ":" + String.valueOf(converted.getAttribute((String)ss))));
                continue;
            }
            System.err.println("Failed: " + s);
        }
        System.err.println("Total converted sessions: " + keys.size());
    }

    public static final void usage() {
        System.err.println("Usage:  InfinispanSessionLegacyConverter [-Dhost=127.0.0.1] [-Dverbose=true] <cache-name> [check]");
    }

    public static final void main(String ... args) {
        if (args == null || args.length < 1) {
            InfinispanSessionLegacyConverter.usage();
            System.exit(1);
        }
        try {
            InfinispanSessionLegacyConverter converter = new InfinispanSessionLegacyConverter(args[0]);
            if (args.length == 1) {
                converter.convert();
            } else if (args[1].equals("check")) {
                converter.checkConverted();
            } else {
                InfinispanSessionLegacyConverter.usage();
            }
        }
        catch (Exception e) {
            System.err.println("Conversion failure");
            e.printStackTrace();
        }
    }
}

