/*
 * Decompiled with CFR 0.152.
 */
package ai.vavilon;

import ai.vavilon.CoderTask;
import ai.vavilon.utils.Gpt;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.utils.Utils;

public class CodeOptimizer
implements Runnable {
    static List<String> EXCEPTIONS = Utils.list("strings", "utils", "tests");

    static boolean isException(String filepath) {
        for (String exception : EXCEPTIONS) {
            if (!filepath.contains("/" + exception)) continue;
            return true;
        }
        return false;
    }

    public static void optimize(List<String> files, List<String> context) {
        for (String filepath : files) {
            try {
                if (CodeOptimizer.isException(filepath)) continue;
                System.out.println(filepath + " " + Utils.readFileLines(filepath).size());
                String response = Gpt.gpt("\u0418\u0441\u043f\u0440\u0430\u0432\u044c \u0433\u0440\u0443\u0431\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0435\u0441\u043b\u0438 \u043e\u043d\u0438 \u0435\u0441\u0442\u044c", context, filepath);
                Utils.writeFile(filepath, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        ArrayList<String> context = new ArrayList<String>();
        context.addAll(CoderTask.JAVA_CONTEXT);
        context.add("\u0443\u0431\u0435\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u044b \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f");
        CodeOptimizer.optimize(Utils.getFilesRecAbsolute("C:/Users/user/Desktop/servers/", "java"), context);
        for (String dir : Utils.getDirectories("c:/wamp/www/node_modules/", "mfm-")) {
            CodeOptimizer.optimize(Utils.getFilesAbsolute("c:/wamp/www/node_modules/" + dir, "js"), CoderTask.JS_CONTEXT);
        }
    }

    public static void main(String[] args) {
        new CodeOptimizer().run();
    }
}

