/*
 * Decompiled with CFR 0.152.
 */
package ai.vavilon.junit;

import ai.vavilon.junit.TestRunner;
import ai.vavilon.utils.Gpt;
import java.util.Map;
import net.vavilon.utils.Utils;

public class JunitBugfixer {
    private static void fixOnce(String projectPath, String packageName, String className) throws Exception {
        String classPath = projectPath + "src/" + packageName.replace(".", "/") + "/" + className + ".java";
        String original = Utils.readFile(classPath);
        Map<String, String> errors = TestRunner.getMapClassToError(packageName + "." + className);
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder prompt = new StringBuilder("\u0418\u0441\u043f\u0440\u0430\u0432\u044c \u043e\u0448\u0438\u0431\u043a\u0438:\n");
        for (String error : errors.values()) {
            prompt.append(error).append("\n");
        }
        prompt.append(Utils.readFile(projectPath + "test/" + packageName.replace(".", "/") + "/" + className + "Test.java"));
        String fixed = Gpt.gpt(prompt.toString(), Utils.list(new String[0]), classPath);
        if (Utils.isNotEmpty(fixed)) {
            Utils.writeFile(classPath, fixed);
            Map<String, String> postErrors = TestRunner.getMapClassToError(packageName + "." + className);
            if (!postErrors.isEmpty()) {
                Utils.writeFile(classPath, original);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JunitBugfixer.fixOnce("C:/Users/user/Desktop/servers/", "com.metabrain.gdb", "BigArray");
    }
}

