/*
 * Decompiled with CFR 0.152.
 */
package ai.vavilon.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;

public class Gpt {
    public static final String MODULES = "c:/wamp/www/node_modules/";
    public static final String SERVERS = "C:/Users/user/Desktop/servers/";
    public static final String GPT_HOST = "http://localhost:1234";

    public static String gpt(String prompt, List<String> context, String inputFilepath) throws Exception {
        List<String> lines = Utils.list(new String[0]);
        lines.add(prompt);
        lines.addAll(context);
        lines.add("\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0439 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0442\u043e\u0433\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b, \u0431\u0435\u0437 markdown-\u0431\u043b\u043e\u043a\u043e\u0432:");
        prompt = String.join((CharSequence)"\r\n", lines) + (!Utils.fileExists(inputFilepath) ? "" : "\n" + Utils.readFile(inputFilepath));
        String answerFile = "c:/wamp/www/node_modules/db-gpt/" + Utils.hash(prompt);
        String answer = Utils.readFile(answerFile);
        if (answer != null) {
            return answer;
        }
        String result = Request.post("http://localhost:1234/v1/completions", Request.map("model", "openai/gpt-oss-20b", "prompt", prompt, "max_tokens", 16000, "temperature", 0));
        try {
            LLMResponse response = (LLMResponse)Request.gson.fromJson(result, LLMResponse.class);
            if (response.choices.size() > 0) {
                answer = Gpt.extractMessage(response.choices.get((int)0).text);
                answer = answer.replace("\r\n", "\n");
                answer = answer.replace("\n", "\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Utils.isEmpty(answer)) {
            throw new NullPointerException();
        }
        Utils.writeFile(answerFile, answer);
        return answer;
    }

    private static String extractMessage(String text) {
        String lastTag = "<|message|>";
        int start = text.lastIndexOf(lastTag);
        return start != -1 ? text.substring(start + lastTag.length()).trim() : text.trim();
    }

    public static String executeCommand(String workingDir, String command) throws IOException {
        return Gpt.execute(new ProcessBuilder("cmd.exe", "/c", command), workingDir);
    }

    public static String executeCommand(String workingDir, List<String> command) throws IOException {
        return Gpt.execute(new ProcessBuilder(command), workingDir);
    }

    public static String executeCommand(String workingDir) throws IOException {
        return Gpt.execute(new ProcessBuilder(new String[0]), workingDir);
    }

    private static String execute(ProcessBuilder builder, String workingDir) throws IOException {
        if (workingDir != null && !workingDir.isEmpty()) {
            builder.directory(new File(workingDir));
        }
        builder.redirectErrorStream(true);
        Process process = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder output = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            output.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
        }
        System.out.println(output);
        return output.toString();
    }

    public class LLMResponse {
        public List<Choice> choices;

        public class Choice {
            public String text;
        }
    }
}

