/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.BigFile;
import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class BigArray<Type extends BigArrayCell>
extends BigFile {
    private final Class<Type> type;
    private final long cellSize;
    private final Map<Long, Type> cache;
    private final Deque<Long> recentRequests;
    private final Map<Long, Integer> requestCounts;
    private int maxQueueSize;
    private final int initialCacheSize;
    private long lastIntervalStart = System.currentTimeMillis();
    private int requestsThisInterval = 0;
    private double requestsPerInterval = 0.0;
    private final long INTERVAL_MS = 5000L;

    public BigArray(String app, String filename, Class<Type> type) {
        this(app, filename, type, Long.MAX_VALUE, 50);
    }

    public BigArray(String app, String filename, Class<Type> type, Long maxBlocks) {
        this(app, filename, type, maxBlocks, 50);
    }

    public BigArray(String app, String filename, Class<Type> type, Long maxBlocks, int initialCacheSize) {
        super(app, filename, maxBlocks);
        this.type = type;
        this.cellSize = this.createValInstance().build().length;
        if (this.cellSize == 0L) {
            throw new NullPointerException();
        }
        this.cache = new HashMap<Long, Type>();
        this.recentRequests = new ArrayDeque<Long>();
        this.requestCounts = new HashMap<Long, Integer>();
        this.initialCacheSize = initialCacheSize;
        this.maxQueueSize = initialCacheSize;
    }

    public Type createValInstance() {
        try {
            return (Type)((BigArrayCell)this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type get(long index) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            this.recordAccess(index);
            BigArrayCell cached = (BigArrayCell)this.cache.get(index);
            if (cached != null) {
                return (Type)this.cloneCell(cached);
            }
            Type result = this.createValInstance();
            byte[] readiedData = this.readBytes(index * this.cellSize, this.cellSize);
            if (readiedData != null) {
                result.parse(new Bytes(readiedData));
                this.cache.put(index, result);
                return this.cloneCell(result);
            }
        }
        return null;
    }

    private Type cloneCell(Type cell) {
        byte[] bytes = cell.build();
        Type copy = this.createValInstance();
        copy.parse(new Bytes(bytes));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long index, Type obj) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            this.writeBytes(index * this.cellSize, obj.build());
            this.cache.put(index, obj);
            this.recordAccess(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(Type obj) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            long idx = super.addBytes(obj.build()) / this.cellSize - 1L;
            this.cache.put(idx, obj);
            this.recordAccess(idx);
            return idx;
        }
    }

    public long size() {
        return this.fileSize / this.cellSize;
    }

    public long nextId() {
        return this.size();
    }

    private void recordAccess(long index) {
        ++this.requestsThisInterval;
        long now = System.currentTimeMillis();
        if (now - this.lastIntervalStart >= 5000L) {
            this.requestsPerInterval = this.requestsThisInterval;
            this.requestsThisInterval = 0;
            this.lastIntervalStart = now;
            if (this.requestsPerInterval > (double)this.maxQueueSize) {
                this.maxQueueSize = (int)(this.requestsPerInterval * 1.2);
            } else if (this.requestsPerInterval < (double)(this.maxQueueSize / 2) && this.maxQueueSize > this.initialCacheSize) {
                this.maxQueueSize = Math.max(this.initialCacheSize, this.maxQueueSize / 2);
            }
            this.enforceCacheLimit();
        }
        this.recentRequests.addLast(index);
        Integer count = this.requestCounts.get(index);
        this.requestCounts.put(index, count == null ? 1 : count + 1);
        this.enforceCacheLimit();
    }

    private void enforceCacheLimit() {
        while (this.recentRequests.size() > this.maxQueueSize) {
            long removed = this.recentRequests.removeFirst();
            Integer count = this.requestCounts.get(removed);
            if (count == null) continue;
            if (count <= 1) {
                this.requestCounts.remove(removed);
                this.cache.remove(removed);
                continue;
            }
            this.requestCounts.put(removed, count - 1);
        }
    }
}

