/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.Top;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiTop<T extends Top.TopId> {
    private final Map<String, Top<T>> cache = new HashMap<String, Top<T>>();
    private final Comparator<T> comparator;
    private final int max;
    private final Class<T> type;
    private final String app;
    private final String dir;

    public MultiTop(String app, String dir, Class<T> type, Comparator<T> comparator, int max) {
        this.app = app;
        this.dir = dir;
        this.type = type;
        this.comparator = comparator;
        this.max = max;
    }

    private Top<T> getOrCreateTop(String id) {
        return this.cache.computeIfAbsent(id, id1 -> new Top<T>(this.app + "/mtop_" + this.dir, (String)id1, this.type, this.comparator, this.max));
    }

    public void put(String id, T item) {
        Top<T> top = this.getOrCreateTop(id);
        top.add(item);
    }

    public List<T> getTop(String id) {
        return this.getOrCreateTop(id).getTop();
    }

    public void clearTop(String id) {
        this.getOrCreateTop(id).clearTop();
    }
}

