/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.model;

import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.model.SearchItem;
import com.metabrain.gdb.utils.Bytes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.vavilon.utils.Utils;

public class SearchList
implements BigArrayCell {
    private List<SearchItem> items = new ArrayList<SearchItem>();

    public void put(String key, String value, Long weight) {
        if (Utils.isNotEmpty(key) && Utils.isNotEmpty(value)) {
            weight = weight == null ? 1L : weight;
            boolean isExist = false;
            for (SearchItem item : this.items) {
                if (!item.key.equals(key)) continue;
                SearchItem searchItem = item;
                searchItem.weight = searchItem.weight + 1L;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.items.add(new SearchItem(key, value, weight));
            }
            Collections.sort(this.items, (o1, o2) -> {
                boolean o1Matches = o1.key.equals(key);
                boolean o2Matches = o2.key.equals(key);
                if (o1Matches && !o2Matches) {
                    return -1;
                }
                if (!o1Matches && o2Matches) {
                    return 1;
                }
                return Long.compare(o1.weight, o2.weight);
            });
            if (this.items.size() > 10) {
                this.items.remove(this.items.size() - 1);
            }
        }
    }

    @Override
    public byte[] build() {
        Bytes bytes = new Bytes();
        for (int i = 0; i < 10; ++i) {
            SearchItem searchItem = i < this.items.size() ? this.items.get(i) : null;
            bytes.addString32(searchItem != null ? searchItem.key : null);
            bytes.addString32(searchItem != null ? searchItem.value : null);
            bytes.addLong(searchItem != null ? searchItem.weight : null);
        }
        return bytes.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        for (int i = 0; i < 10; ++i) {
            SearchItem item = new SearchItem(data.readString32(), data.readString32(), data.readLong());
            if (!Utils.isNotEmpty(item.key)) continue;
            this.items.add(item);
        }
    }

    public List<SearchItem> getList() {
        return this.items;
    }
}

