/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.model;

import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;

public class String64
implements BigArrayCell {
    private String value;

    public String64() {
    }

    public String64(String value) {
        if (value == null || value.length() > 64) {
            throw new RuntimeException("String64 value length must be less than or equal to 64");
        }
        this.value = value;
    }

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addString64(this.value);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.value = data.readString64();
    }

    public String toString() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

