/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.model.chain;

import com.metabrain.gdb.model.chain.BigChainCell;
import com.metabrain.gdb.utils.Bytes;
import net.vavilon.utils.Utils;

public class String128ChainCell
extends BigChainCell {
    private String value;

    public String128ChainCell(String value) {
        if (value.length() > 128) {
            Utils.error("String128 value length must be less than or equal to 128");
        }
        this.value = value;
    }

    @Override
    public byte[] build() {
        Bytes data = new Bytes(super.build());
        data.addString128(this.value);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        super.parse(data);
        this.value = data.readString128();
    }

    public String toString() {
        return this.value;
    }
}

