/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Bytes {
    private byte[] bytes;
    private int position;

    public Bytes() {
        this.bytes = new byte[0];
        this.position = 0;
    }

    public Bytes(byte[] bytes) {
        this.bytes = bytes;
        this.position = 0;
    }

    public byte[] read(int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, this.position, result, 0, length);
        this.position += length;
        return result;
    }

    public String readString8() {
        return Bytes.toString(this.read(8));
    }

    public String readString32() {
        return Bytes.toString(this.read(32));
    }

    public String readString64() {
        return Bytes.toString(this.read(64));
    }

    public String readString128() {
        return Bytes.toString(this.read(128));
    }

    public String readString1024() {
        return Bytes.toString(this.read(1024));
    }

    public String readString(int length) {
        return Bytes.toString(this.read(length));
    }

    public Double readDouble() {
        return Bytes.toDouble(this.read(8));
    }

    public Long readLong() {
        return Bytes.toLong(this.read(8));
    }

    public long[] readLongArray() {
        return Bytes.toLongArray(this.bytes);
    }

    public void addBytes(byte[] bytes) {
        this.bytes = Bytes.concat(this.bytes, bytes);
    }

    public void addString8(String string) {
        this.addBytes(Bytes.fromString(string, 8));
    }

    public void addString32(String string) {
        this.addBytes(Bytes.fromString(string, 32));
    }

    public void addString64(String string) {
        this.addBytes(Bytes.fromString(string, 64));
    }

    public void addString128(String string) {
        this.addBytes(Bytes.fromString(string, 128));
    }

    public void addString1024(String string) {
        this.addBytes(Bytes.fromString(string, 1024));
    }

    public void addDouble(Double value) {
        this.addBytes(Bytes.fromDouble(value));
    }

    public void addLong(Long value) {
        this.addBytes(Bytes.fromLong(value));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static byte[] fromInt(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static int toInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static byte[] fromLong(Long value) {
        return ByteBuffer.allocate(8).putLong(value == null ? 0L : value).array();
    }

    public static byte[] fromDouble(Double value) {
        return ByteBuffer.allocate(8).putDouble(value == null ? 0.0 : value).array();
    }

    public static long toLong(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static byte[] fromChar(char value) {
        byte[] result = new byte[]{(byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        return result;
    }

    public static char toChar(byte[] bytes) {
        return (char)(((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF));
    }

    public static int[] toIntArray(byte[] bytes) {
        IntBuffer intBuffer = ByteBuffer.wrap(bytes).asIntBuffer();
        int[] result = new int[intBuffer.capacity()];
        intBuffer.get(result);
        return result;
    }

    public static byte[] fromIntArray(int[] value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(value.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(value);
        return byteBuffer.array();
    }

    public static long[] toLongArray(byte[] bytes) {
        LongBuffer longBuffer = ByteBuffer.wrap(bytes).asLongBuffer();
        long[] result = new long[longBuffer.capacity()];
        longBuffer.get(result);
        return result;
    }

    public static byte[] fromLongArray(long[] arr) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(arr.length * 8);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(arr);
        return byteBuffer.array();
    }

    public static byte[] fromLongList(ArrayList<Long> arr) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(arr.size() * 8);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            longBuffer.put(i, arr.get(i));
        }
        return byteBuffer.array();
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] append(byte[] a, byte[] b) {
        return Bytes.concat(a, b);
    }

    public static byte[] fromCharArray(char[] chars) {
        return Charset.forName("UTF-8").encode(CharBuffer.wrap(chars)).array();
    }

    public static char[] toCharArray(byte[] bytes) {
        return new String(bytes).toCharArray();
    }

    public static byte[] fromString(String string) {
        return string.getBytes();
    }

    public static byte[] fromString(String string, int minSize) {
        if (string == null) {
            string = "";
        }
        byte[] bytes = new byte[minSize];
        byte[] stringBytes = string.getBytes();
        System.arraycopy(stringBytes, 0, bytes, 0, stringBytes.length);
        return bytes;
    }

    public static String toString(byte[] bytes) {
        return Bytes.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] data, int offset, int size) {
        int firstZeroIndex = size;
        for (int i = 0; i < size; ++i) {
            if (data[offset + i] != 0) continue;
            firstZeroIndex = i;
            break;
        }
        return firstZeroIndex == 0 ? null : new String(data, offset, firstZeroIndex);
    }

    public static Double toDouble(byte[] data, int offset) {
        return ByteBuffer.wrap(data, offset, 8).getDouble();
    }

    public static Double toDouble(byte[] data) {
        return ByteBuffer.wrap(data).getDouble();
    }

    public static Long toLong(byte[] data, int offset) {
        return ByteBuffer.wrap(data, offset, 8).getLong();
    }
}

