/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private File iniFile;
    private Pattern section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private Pattern keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
    private Map<String, Map<String, String>> entries = new HashMap<String, Map<String, String>>();

    public IniFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isFile() && !file.createNewFile()) {
            throw new FileNotFoundException();
        }
        this.iniFile = file;
        this.load();
    }

    public IniFile(String filePath) throws IOException {
        this(new File(filePath));
    }

    public IniFile(File dir, String fileName) throws IOException {
        this(dir.getAbsolutePath() + "/" + fileName);
    }

    public void load() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.iniFile));){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                Matcher m = this.section.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    continue;
                }
                if (section == null || !(m = this.keyValue.matcher(line)).matches()) continue;
                String key = m.group(1).trim();
                String value = m.group(2).trim();
                Map<String, String> kv = this.entries.get(section);
                if (kv == null) {
                    kv = new HashMap<String, String>();
                    this.entries.put(section, kv);
                }
                kv.put(key, URLDecoder.decode(value));
            }
        }
    }

    public void save() {
        try {
            this.iniFile.delete();
            this.iniFile.createNewFile();
            PrintWriter out = new PrintWriter(this.iniFile);
            for (String sectionKey : this.entries.keySet()) {
                out.println("[" + sectionKey + "]");
                Map<String, String> section = this.entries.get(sectionKey);
                for (String paramKey : section.keySet()) {
                    String paramValue = section.get(paramKey);
                    if (paramValue == null) continue;
                    out.println(paramKey + "=" + URLEncoder.encode(paramValue));
                }
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Map<String, String>> getEntries() {
        return this.entries;
    }

    public Map<String, String> getSection(String section) {
        return this.entries.get(section);
    }

    public String get(String section, String key, String defaultValue) {
        Map<String, String> kv = this.entries.get(section);
        if (kv == null) {
            return defaultValue;
        }
        return kv.get(key);
    }

    public String get(String section, String key) {
        return this.get(section, key, null);
    }

    public void put(String sectionKey, String key, String value) {
        Map<String, String> section = this.entries.get(sectionKey);
        if (section != null) {
            section.put(key, value);
        } else {
            section = new HashMap<String, String>();
            section.put(key, value);
            this.entries.put(sectionKey, section);
        }
        this.save();
    }

    public Long getLong(String section, String key, Long defaultValue) {
        String data = this.get(section, key);
        if (data == null) {
            return defaultValue;
        }
        return Long.valueOf(data);
    }

    public Integer getInt(String section, String key, Integer defaultValue) {
        String data = this.get(section, key);
        if (data == null) {
            return defaultValue;
        }
        return Integer.valueOf(data);
    }
}

