/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon;

import com.metabrain.gdb.BigFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.vavilon.NodeInit;
import net.vavilon.charts.GetChart;
import net.vavilon.contract.CraftDefcraft;
import net.vavilon.contract.Epoch;
import net.vavilon.contract.EpochFinish;
import net.vavilon.contract.MiningInfo;
import net.vavilon.contract.Mint10;
import net.vavilon.contract.Mint100;
import net.vavilon.contract.Mint20;
import net.vavilon.contract.tests.SimpleMiner;
import net.vavilon.servers.HttpServer;
import net.vavilon.servers.model.Post;
import net.vavilon.storage.Copy;
import net.vavilon.token.AccountInfo;
import net.vavilon.token.Accounts;
import net.vavilon.token.AccountsTop;
import net.vavilon.token.AirdropTop;
import net.vavilon.token.Search;
import net.vavilon.token.Send;
import net.vavilon.token.TokenInfo;
import net.vavilon.token.TokenProfile;
import net.vavilon.token.Tokens;
import net.vavilon.token.TransactionInfo;
import net.vavilon.token.Transactions;
import net.vavilon.utils.Utils;

public class Node
extends HttpServer {
    public static String masterNode;
    public static boolean isStarted;

    public static void main(String[] args) throws Exception {
        String masterNode = null;
        if (args.length >= 1) {
            masterNode = args[0];
        }
        new Node(masterNode).start();
        new Scanner(System.in).hasNext();
    }

    protected static boolean isNeedRecalc() {
        return Send.requests.size() == 0L && new File("requests.json").exists();
    }

    public Node(String masterNode) throws Exception {
        Node.masterNode = masterNode;
        if (masterNode == null) {
            new NodeInit();
        } else if (Node.isNeedRecalc()) {
            this.parseRequestsAndCommit();
        }
    }

    void parseRequestsAndCommit() {
        File file = new File("requests.json");
        if (!file.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (sb.length() == 0 && !line.startsWith("{")) {
                    sb.append("{");
                }
                if (line.equals("},{")) {
                    sb.append("}");
                    this.processRequestJson(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processRequestJson(String json) {
        block3: {
            try {
                Map<String, Object> obj = Utils.parseMap(json);
                if (obj != null && !obj.isEmpty()) {
                    this.commitRequests(Collections.singletonList(obj));
                }
            }
            catch (Exception e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 JSON: " + json);
                e.printStackTrace();
                if (!BigFile.isDebugMode) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    void commitRequests(List<Map<String, Object>> requests) {
        for (Map<String, Object> params : requests) {
            try {
                if (params.isEmpty()) continue;
                String path = (String)params.getOrDefault("path", "mfm-token/send");
                this.getEndpointByQuery(path).run(path, params);
            }
            catch (Exception e) {
                System.err.println(Utils.gson.toJson(params));
                e.printStackTrace();
                if (!BigFile.isDebugMode) continue;
                throw new NullPointerException();
            }
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (Utils.isEmpty(masterNode)) {
            Thread thread = new Thread(new SimpleMiner("localhost"));
            thread.start();
            Thread.sleep(1000L);
            thread.interrupt();
        } else if (!masterNode.equals("localhost")) {
            // empty if block
        }
        isStarted = true;
    }

    @Override
    public Post getEndpoint(String uri) {
        switch (uri) {
            case "mfm-chart/chart": {
                return new GetChart();
            }
            case "mfm-token/token": {
                return new TokenInfo();
            }
            case "mfm-token/tokens": {
                return new Tokens();
            }
            case "mfm-token/profile": {
                return new TokenProfile();
            }
            case "mfm-token/send": {
                return new Send();
            }
            case "mfm-token/account": {
                return new AccountInfo();
            }
            case "mfm-token/accounts": {
                return new Accounts();
            }
            case "mfm-token/accounts_top": {
                return new AccountsTop();
            }
            case "mfm-token/search": {
                return new Search();
            }
            case "mfm-token/top": {
                return new AirdropTop();
            }
            case "mfm-token/tran": {
                return new TransactionInfo();
            }
            case "mfm-token/trans": {
                return new Transactions();
            }
            case "mfm-contract/mint10": {
                return new Mint10();
            }
            case "mfm-contract/mint20": {
                return new Mint20();
            }
            case "mfm-contract/mint100": {
                return new Mint100();
            }
            case "mfm-contract/mining_info": {
                return new MiningInfo();
            }
            case "mfm-contract/epoch_finish": {
                return new EpochFinish();
            }
            case "mfm-contract/epoch": {
                return new Epoch();
            }
            case "mfm-contract/craft": {
                return new CraftDefcraft();
            }
            case "mfm-storage/copy": {
                return new Copy();
            }
        }
        return null;
    }

    Post getEndpointByQuery(String url) {
        String path = Utils.extractUrlPath(url);
        return this.getEndpoint(path);
    }

    static {
        isStarted = false;
        if (BigFile.isDebugMode) {
            Utils.deleteDirRecursively("db-tokens");
        }
    }

    public static class Response {
        public List<Map<String, Object>> history;
    }
}

