/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.charts;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.BigFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vavilon.charts.model.Candle;
import net.vavilon.utils.Utils;

public abstract class Chart {
    static final Map<String, BigArray<Candle>> charts = new ConcurrentHashMap<String, BigArray<Candle>>();
    static final Map<String, Long> periodsSec = new HashMap<String, Long>();
    public static long TIME_MULTIPLICATOR = 1L;

    public static BigArray<Candle> getChart(String app, String key, String periodName) {
        return charts.computeIfAbsent(key + periodName, k -> new BigArray<Candle>(app + "/chart", key + periodName, Candle.class, periodName.equals("M") ? 2L : Long.MAX_VALUE));
    }

    public static List<Candle> getCandles(String app, String key, String periodName, int count) {
        long periodTime;
        BigArray<Candle> chart = Chart.getChart(app, key, periodName);
        long periodSec = periodsSec.get(periodName);
        ArrayList<Candle> result = new ArrayList<Candle>();
        if (chart.size() == 0L) {
            return result;
        }
        Candle firstCandle = null;
        Candle lastCandle = null;
        HashMap<Long, Candle> candlesMap = new HashMap<Long, Candle>();
        for (long i = Math.max(chart.size() - (long)count, 0L); i < chart.size(); ++i) {
            Candle candle = chart.get(i);
            if (firstCandle == null) {
                firstCandle = candle;
            }
            lastCandle = candle;
            candlesMap.put(candle.time, candle);
        }
        double lastClose = lastCandle.close;
        for (long i = periodTime = Utils.currentTimeSec() / periodSec * periodSec; i >= firstCandle.time && result.size() < count; i -= periodSec) {
            Candle item = (Candle)candlesMap.get(i);
            if (item == null) {
                Candle newCandle = new Candle();
                newCandle.time = (int)i;
                newCandle.low = lastClose;
                newCandle.high = lastClose;
                newCandle.open = lastClose;
                newCandle.close = lastClose;
                result.add(newCandle);
                continue;
            }
            lastClose = item.open;
            result.add(item);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Candle> getAccumulate(String app, String key, String periodName, int count) {
        List<Candle> candles = Chart.getCandles(app, key, periodName, count);
        for (Candle candle : candles) {
            candle.open = Utils.round(candle.open);
            candle.close = Utils.round(candle.close);
            candle.high = Utils.round(candle.high);
            candle.low = Utils.round(candle.low);
            candle.value = Utils.round(candle.close - candle.open);
        }
        return candles;
    }

    public static double getChartLastValue(String app, String key) {
        return Chart.getChartLastValue(app, key, "M");
    }

    public static double getChartLastValue(String app, String key, String periodName) {
        BigArray<Candle> chart = Chart.getChart(app, key, periodName);
        if (chart.size() == 0L) {
            return 0.0;
        }
        return chart.get((long)(chart.size() - 1L)).close;
    }

    public static double getChange1hPercent(String app, String key) {
        return Chart.getChangePercent(app, key, "H", 1);
    }

    public static double getChange24hPercent(String app, String key) {
        return Chart.getChangePercent(app, key, "H", 24);
    }

    private static double getChangePercent(String app, String key, String periodName, int count) {
        List<Candle> chart = Chart.getCandles(app, key, periodName, count + 1);
        if (chart.isEmpty()) {
            return 0.0;
        }
        if (chart.size() == 1) {
            Candle candle = chart.get(0);
            if (candle.open == 0.0) {
                return 0.0;
            }
            return (candle.close - candle.open) / candle.open * 100.0;
        }
        double firstClose = chart.get((int)0).close;
        double lastClose = chart.get((int)(chart.size() - 1)).close;
        if (firstClose == 0.0) {
            return 0.0;
        }
        return (lastClose - firstClose) / firstClose * 100.0;
    }

    public static double getChange24hTotal(String app, String key) {
        return Chart.getChangeTotal(app, key, "H", 24);
    }

    public static double getChart7dTotal(String app, String key) {
        return Chart.getChangeTotal(app, key, "D", 7);
    }

    public static double getChangeTotal(String app, String key, String periodName, int count) {
        List<Candle> chart = Chart.getCandles(app, key, periodName, count + 1);
        if (chart.size() == 0) {
            return 0.0;
        }
        if (chart.size() == 1) {
            Candle candle = chart.get(0);
            return candle.close - candle.open;
        }
        return chart.get((int)(chart.size() - 1)).close - chart.get((int)0).close;
    }

    static {
        TIME_MULTIPLICATOR = BigFile.isDebugMode ? 1L : 1L;
        periodsSec.put("M", Math.max(1L, 60L / TIME_MULTIPLICATOR));
        periodsSec.put("H", Math.max(1L, 3600L / TIME_MULTIPLICATOR));
        periodsSec.put("D", Math.max(1L, 86400L / TIME_MULTIPLICATOR));
    }
}

