/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.charts;

import com.metabrain.gdb.BigArray;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.charts.Chart;
import net.vavilon.charts.model.Candle;
import net.vavilon.servers.model.Post;

public abstract class PostChart
extends Post {
    public List<CandleTick> newCandles = new ArrayList<CandleTick>();

    public void trackLinear(String app, String key, double value) {
        CandleTick tick = new CandleTick();
        tick.app = app;
        tick.key = key;
        tick.value = value;
        this.newCandles.add(tick);
    }

    public void trackAccumulate(String app, String key) {
        this.trackAccumulate(app, key, 1.0);
    }

    public void trackAccumulate(String app, String key, double value) {
        this.trackLinear(app, key, Chart.getChartLastValue(app, key) + value);
    }

    @Override
    public void commit() {
        for (CandleTick tick : this.newCandles) {
            long timestamp = this.time();
            for (String periodName : Chart.periodsSec.keySet()) {
                long periodSec = Chart.periodsSec.get(periodName);
                long periodTime = timestamp / periodSec * periodSec;
                BigArray<Candle> chart = Chart.getChart(tick.app, tick.key, periodName);
                Candle lastCandle = null;
                if (chart.size() != 0L) {
                    lastCandle = chart.get(chart.size() - 1L);
                }
                if (lastCandle == null || periodTime != lastCandle.time) {
                    Candle candle = new Candle();
                    candle.period = periodName;
                    candle.time = periodTime;
                    candle.low = tick.value;
                    candle.high = tick.value;
                    candle.open = tick.value;
                    candle.close = tick.value;
                    chart.add(candle);
                    continue;
                }
                lastCandle.low = Math.min(lastCandle.low, tick.value);
                lastCandle.high = Math.max(lastCandle.high, tick.value);
                lastCandle.close = tick.value;
                chart.set(chart.size() - 1L, lastCandle);
            }
        }
    }

    class CandleTick {
        String app;
        String key;
        Double value;

        CandleTick() {
        }
    }
}

