/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import com.metabrain.gdb.BigChain;
import com.metabrain.gdb.BigChain64;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.contract.EpochFinish;
import net.vavilon.contract.model.Data;
import net.vavilon.contract.model.PathValue;
import net.vavilon.servers.WssServer;
import net.vavilon.token.Send;
import net.vavilon.utils.Utils;

public abstract class Contract
extends Send {
    public static final double DATA_GAS_FOR_ROW = 1.0E-4;
    public static final String GAS_DOMAIN = "usdt";
    public static final String VAVILON = "vavilon";
    public static final BigChain64 dataAll = new BigChain64("tokens", "allData");
    public static final BigChain<PathValue> dataByTran = new BigChain<PathValue>("tokens", "dataByTran", PathValue.class);
    public List<Data> dataNew = new ArrayList<Data>();

    public void dataSet(String path, String value) {
        if (path.length() > 64) {
            Utils.error("Path too long");
        }
        if (value.length() > 64) {
            Utils.error("Value too long");
        }
        Data data = new Data();
        data.path = path;
        data.value = value;
        this.dataNew.add(data);
    }

    public static Double dataGetDouble(String path) {
        String response = Contract.dataGet(path);
        if (response == null) {
            return null;
        }
        return Double.parseDouble(response);
    }

    public static String dataGet(String path) {
        return dataAll.getLastString(path);
    }

    public static Long dataGetLong(String path, Long defaultValue) {
        String data = Contract.dataGet(path);
        return data == null ? defaultValue : Long.parseLong(data);
    }

    public static Long dataGetLong(String path) {
        String data = Contract.dataGet(path);
        return data == null ? null : Long.valueOf(Long.parseLong(data));
    }

    public static List<String> dataHistory(String path, long size) {
        return dataAll.getStringsFromEnd(path, size);
    }

    public static List<Long> dataHistoryLong(String path, int size) {
        List<String> strings = Contract.dataHistory(path, size);
        ArrayList<Long> response = new ArrayList<Long>();
        for (String string : strings) {
            response.add(Long.parseLong(string));
        }
        return response;
    }

    @Override
    public void commit() {
        double gas_commission = Utils.round(1.0E-4 * (double)this.dataNew.size());
        if (gas_commission > 0.0) {
            String gas_address = this.getAddress("gas_address");
            String gas_pass = this.getRequired("gas_pass");
            if (Contract.getBalanceOrZero(GAS_DOMAIN, gas_address) < gas_commission) {
                Utils.error("Not enough gas");
            }
            this.regAccount(this.scriptPath, GAS_DOMAIN, EpochFinish.GAS_ADDRESS, EpochFinish.GAS_PASSWORD, null);
            String next_hash = this.tokenSend(this.scriptPath, GAS_DOMAIN, gas_address, EpochFinish.GAS_ADDRESS, gas_commission, gas_pass, null);
            super.commit();
            for (Data data : this.dataNew) {
                dataAll.addLast(data.path, data.value);
                dataByTran.addLast(next_hash, new PathValue(data.path, data.value, next_hash));
                WssServer.broadcast("data", Utils.toMap(data));
            }
            this.dataNew.clear();
        } else {
            super.commit();
        }
    }
}

