/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import net.vavilon.contract.Contract;
import net.vavilon.contract.Mint;
import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.token.model.Account;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;

public class MiningInfo
extends Get {
    @Override
    public Get.Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddressNotRequired("address");
        Account bank = Send.getAccount(domain, Mint.MINING_ADDRESS);
        if (bank == null) {
            Utils.error("its not mining token");
        }
        Response response = new Response();
        response.bank = bank;
        response.last_hash = Contract.dataGet("mining/" + domain + "/last_hash");
        response.difficulty = Contract.dataGetLong("mining/" + domain + "/difficulty");
        response.gas_account = Send.getAccount("usdt", address);
        response.token_account = Send.getAccount(domain, address);
        return response;
    }

    public static Response request(String domain) {
        return MiningInfo.request(domain, null);
    }

    public static Response request(String domain, String address) {
        return (Response)new MiningInfo().run(null, Request.map("domain", domain, "address", address));
    }

    public class Response
    extends Get.Response {
        public String last_hash;
        public Long difficulty;
        public Account bank;
        public Account gas_account;
        public Account token_account;
    }
}

