/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import java.math.BigInteger;
import java.time.Duration;
import java.util.List;
import net.vavilon.charts.Chart;
import net.vavilon.contract.Contract;
import net.vavilon.servers.WssServer;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;

public abstract class Mint
extends Contract {
    public static final String MINING_SEED = "card wing home athlete regular post notice paddle isolate zone payment chef";
    public static final String MINING_PASSWORD = Utils.hash("card wing home athlete regular post notice paddle isolate zone payment chef");
    public static final String MINING_ADDRESS = Mint.hashAddress(MINING_PASSWORD);

    abstract double getPercentInYear();

    public static double calcMintRewardPerMin(String domain, double percentInYear) {
        return Mint.calcMintRewardPerMin(Mint.getBalanceOrZero(domain, MINING_ADDRESS), percentInYear);
    }

    public static double calcMintRewardPerMin(double locked_supply, double percentInYear) {
        double minutesInYear = 525600.0;
        return Utils.round(locked_supply * (percentInYear / 100.0) / minutesInYear);
    }

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        String gas_address = this.getAddress("gas_address");
        Long nonce = this.getLongRequired("nonce");
        Long time = this.getTimeRequired("time");
        this.emulateTime(time);
        String lastHash = Mint.dataGet("mining/" + domain + "/last_hash");
        Long difficulty = Mint.dataGetLong("mining/" + domain + "/difficulty", 1L);
        Long lastTime = Mint.dataGetLong("mining/" + domain + "/last_time", 0L);
        String str = lastHash + domain + nonce;
        String newHash = Utils.hash(str);
        BigInteger hashNumber = new BigInteger(newHash, 16);
        hashNumber = hashNumber.mod(BigInteger.valueOf(difficulty));
        if (hashNumber.equals(BigInteger.ZERO)) {
            double locked_supply = Mint.getBalanceOrZero(domain, MINING_ADDRESS);
            double reward = Mint.calcMintRewardPerMin(locked_supply, this.getPercentInYear());
            this.tokenSend(this.scriptPath, domain, MINING_ADDRESS, gas_address, reward, Mint.tokenPass(domain, MINING_ADDRESS, MINING_PASSWORD), null);
            long interval = time - (lastTime == null ? 0L : lastTime);
            long timeDiff = interval - Duration.ofMinutes(1L).getSeconds();
            int axelerate = 0;
            List<Long> difficultyHistory = Mint.dataHistoryLong("mining/" + domain + "/difficulty", 20);
            for (int i = 0; i < difficultyHistory.size() - 1; ++i) {
                if (difficultyHistory.get(i) > difficultyHistory.get(i + 1)) {
                    ++axelerate;
                }
                if (difficultyHistory.get(i) >= difficultyHistory.get(i + 1)) continue;
                --axelerate;
            }
            int difficultyDiff = (int)Math.pow(2.0, Math.abs(axelerate));
            if (timeDiff == 0L) {
                difficultyDiff = 0;
            } else if (timeDiff > 0L) {
                difficultyDiff = -difficultyDiff;
            }
            difficulty = difficulty + (long)difficultyDiff;
            if (difficulty < 1L) {
                difficulty = 1L;
            }
            this.dataSet("mining/" + domain + "/difficulty", "" + difficulty);
            this.dataSet("mining/" + domain + "/last_hash", newHash);
            this.dataSet("mining/" + domain + "/last_time", "" + time);
            this.trackLinear("tokens", domain + "_difficulty", difficulty.longValue());
            Token token = Mint.getToken(domain);
            token.difficulty = difficulty;
            token.difficulty24 = Chart.getChange24hPercent("tokens", domain + "_difficulty");
            token.mint_reward = reward;
            token.locked_supply = locked_supply;
            this.setToken(token);
            WssServer.broadcast("mining:" + domain, Request.map("domain", domain, "difficulty", "" + difficulty, "lastHash", lastHash, "reward", "" + reward, "gas_address", gas_address));
        } else {
            Utils.error("invalid nonce");
        }
    }
}

