/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract.tests;

import java.math.BigInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.vavilon.NodeInit;
import net.vavilon.contract.MiningInfo;
import net.vavilon.servers.WssClient;
import net.vavilon.servers.model.Subscription;
import net.vavilon.token.Send;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.eclipse.jetty.websocket.api.Session;

public class SimpleMiner
implements Runnable {
    static volatile boolean restartFlag = false;
    static ExecutorService executor;
    static final String domain = "vavilon";
    private String host;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            return;
        }
        final int threadCount = Integer.parseInt(args[0]);
        final String host = "vavilon.org";
        new WssClient(host, new WssClient.Callback(){

            @Override
            public void onOpen(Session session) {
                session.sendText(Utils.gson.toJson((Object)new Subscription("mining:vavilon")), null);
            }

            @Override
            public void onMessage(String message) {
                System.out.println("Find new block");
                SimpleMiner.restartMultiThread(host, threadCount);
            }
        }).start();
        SimpleMiner.restartMultiThread(host, threadCount);
    }

    static synchronized void restartMultiThread(String host, int THREAD_COUNT) {
        restartFlag = true;
        try {
            executor.shutdownNow();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        executor = Executors.newFixedThreadPool(THREAD_COUNT);
        restartFlag = false;
        for (int i = 0; i < THREAD_COUNT; ++i) {
            executor.execute(new SimpleMiner(host));
        }
    }

    public SimpleMiner(String host) {
        this.host = host;
    }

    @Override
    public void run() {
        while (!restartFlag && !Thread.currentThread().isInterrupted()) {
            try {
                this.calcBlock();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void calcBlock() throws Exception {
        String infoStr = Request.post(this.host + "/mfm-contract/mining_info", Request.map("domain", domain, "address", NodeInit.USER_ADDRESS));
        if (infoStr != null) {
            MiningInfo.Response info = (MiningInfo.Response)Utils.gson.fromJson(infoStr, MiningInfo.Response.class);
            Long nonce = this.calcNonce(domain, info.last_hash, info.difficulty);
            if (nonce != null) {
                Request.post(this.host + "/" + info.bank.delegate, Request.map("domain", domain, "nonce", "" + nonce, "time", "" + Utils.currentTimeSec(), "gas_address", NodeInit.USER_ADDRESS, "gas_pass", Send.tokenPass("usdt", NodeInit.USER_ADDRESS, NodeInit.USER_PASSWORD, info.gas_account.prev_key)));
            }
        }
    }

    public Long calcNonce(String domain, String lastHash, Long difficulty) {
        if (lastHash == null) {
            lastHash = "";
        }
        if (difficulty == null) {
            difficulty = 1L;
        }
        for (int i = 0; i < 1000000000; ++i) {
            if (restartFlag || Thread.currentThread().isInterrupted()) {
                return null;
            }
            long nonce = (long)(Math.random() * 1.0E9);
            String str = lastHash + domain + nonce;
            String newHash = Utils.hash(str);
            BigInteger hashNumber = new BigInteger(newHash, 16);
            if (!(hashNumber = hashNumber.mod(BigInteger.valueOf(difficulty))).equals(BigInteger.ZERO)) continue;
            return nonce;
        }
        return null;
    }
}

