/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers;

import java.io.File;
import java.util.Collections;
import net.vavilon.utils.Settings;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class FtpServer {
    private static final String APP = "ftp";
    private static final String LOGIN = Settings.get("ftp", "login");
    private static final String PASSWORD = Settings.get("ftp", "password");
    private final int ftpPort = Settings.getInteger("ftp", "port", 21);
    private final int passiveStartPort = Settings.getInteger("ftp", "passive_port_start", 50000);
    private final int passiveEndPort = Settings.getInteger("ftp", "passive_port_end", 50100);
    private org.apache.ftpserver.FtpServer server;

    public void start() {
        try {
            FtpServerFactory serverFactory = new FtpServerFactory();
            ListenerFactory factory = new ListenerFactory();
            DataConnectionConfigurationFactory dataConFactory = new DataConnectionConfigurationFactory();
            dataConFactory.setPassivePorts(this.passiveStartPort + "-" + this.passiveEndPort);
            factory.setDataConnectionConfiguration(dataConFactory.createDataConnectionConfiguration());
            factory.setPort(this.ftpPort);
            serverFactory.addListener("default", factory.createListener());
            PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
            userManagerFactory.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
            UserManager um = userManagerFactory.createUserManager();
            BaseUser user = new BaseUser();
            user.setName(LOGIN);
            user.setPassword(PASSWORD);
            user.setHomeDirectory(new File(".").getAbsolutePath());
            user.setAuthorities(Collections.singletonList(new WritePermission()));
            um.save((User)user);
            serverFactory.setUserManager(um);
            this.server = serverFactory.createServer();
            this.server.start();
            System.out.println("FTP started on port: " + factory.getPort());
        }
        catch (Exception e) {
            System.out.println("FTP failed to start: " + e.getMessage());
        }
    }
}

