/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.Node;
import net.vavilon.servers.WssServer;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;

public abstract class Post
implements Endpoint {
    public Get.Response responseObj = null;
    public String scriptPath;
    public Map<String, String> params = new HashMap<String, String>();
    public Map<String, String> headers = new HashMap<String, String>();
    public Map<String, String> meta = new HashMap<String, String>();
    public Map<String, Object> body = new HashMap<String, Object>();
    Long emulatedTime = null;

    protected void beforeCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Get.Response run(String scriptPath, Map<String, Object> body) {
        this.scriptPath = scriptPath;
        this.params = Request.parseQuery(scriptPath);
        this.body = body;
        this.emulateTime(this.getLong("time", this.time()));
        if (!Node.isStarted && this.time() > Utils.currentTimeSec() + 3L) {
            Utils.error("time difference more than 3 seconds");
        }
        Class<Endpoint> clazz = Endpoint.class;
        synchronized (Endpoint.class) {
            this.run();
            this.beforeCommit();
            this.commit();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (scriptPath != null && (scriptPath.startsWith("mfm-token") || scriptPath.startsWith("mfm-contract")) && (body.get("pass") != null || body.get("gas_pass") != null)) {
                WssServer.broadcast("post", Utils.toMap(body));
            }
            return this.responseObj;
        }
    }

    public Map<String, Object> getBodyAndQueryParams() {
        HashMap<String, Object> full = new HashMap<String, Object>();
        full.put("path", this.scriptPath);
        full.putAll(this.body);
        for (String key : this.params.keySet()) {
            full.put(key, this.params.get(key));
        }
        full.put("time", this.time());
        return full;
    }

    public void emulateTime(Long time) {
        this.emulatedTime = time;
    }

    public Long time() {
        if (this.emulatedTime == null) {
            this.emulatedTime = Utils.currentTimeSec();
        }
        return this.emulatedTime;
    }

    protected Long getTimeRequired(String key) {
        Long value = this.getLongRequired(key);
        return value;
    }

    private Object getParam(String key) {
        Object value = this.params.get(key);
        if (value == null) {
            value = this.body.get(key);
        }
        return value;
    }

    protected String getString(String key, String defaultValue) {
        Object value = this.getParam(key);
        if (value == null || !(value instanceof String)) {
            return defaultValue;
        }
        return (String)value;
    }

    protected String getString(String key) {
        return this.getString(key, null);
    }

    protected String getRequired(String key) {
        String value = this.getString(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected String getAddressNotRequired(String key) {
        String value = this.getString(key);
        if (value != null && value.length() == 64) {
            value = Send.address(value);
        }
        return value;
    }

    protected String getAddress(String key) {
        String value = this.getRequired(key);
        if (value.length() == 64) {
            value = Send.address(value);
        }
        return value;
    }

    protected Long getLong(String key, Long defaultValue) {
        Object value = this.getParam(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (long)((Double)value).doubleValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        return defaultValue;
    }

    protected Long getLong(String key) {
        return this.getLong(key, null);
    }

    protected Long getLongRequired(String key) {
        Long value = this.getLong(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected Double getDouble(String key, Double defaultValue) {
        Object value = this.getParam(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return defaultValue;
    }

    protected Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    protected Double getDoubleRequired(String key) {
        Double value = this.getDouble(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    private void errorEmpty(String key) {
        Utils.error(key + " is empty");
    }

    protected BigDecimal getDecimalRequired(String key) {
        return BigDecimal.valueOf(this.getDoubleRequired(key));
    }

    public String getLanguage() {
        String lang = this.getString("lang");
        if (lang == null) {
            lang = this.getString("Accept-Language");
        }
        if (lang != null) {
            return lang.split(",")[0].split(";")[0].trim();
        }
        return "en";
    }
}

