/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentParser {
    public static final String BROWSER = "browser";
    public static final String BROWSER_VERSION = "browser_version";
    public static final String OS = "os";
    public static final String OS_VERSION = "os_version";
    public static final String DEVICE = "device";
    private static final Pattern[] BROWSER_PATTERNS = new Pattern[]{Pattern.compile("chrome/([0-9]+\\.[0-9]+)"), Pattern.compile("firefox/([0-9]+\\.[0-9]+)"), Pattern.compile("safari/([0-9]+\\.[0-9]+)"), Pattern.compile("msie ([0-9]+\\.[0-9]+)"), Pattern.compile("edge/([0-9]+\\.[0-9]+)")};
    private static final Pattern[] OS_PATTERNS = new Pattern[]{Pattern.compile("windows nt ([0-9]+\\.[0-9]+)"), Pattern.compile("mac os x ([0-9_]+)"), Pattern.compile("linux"), Pattern.compile("android ([0-9]+\\.[0-9]+)"), Pattern.compile("iphone os ([0-9_]+)")};

    public static Map<String, String> parse(String userAgent) {
        HashMap<String, String> result = new HashMap<String, String>();
        String ua = userAgent.toLowerCase();
        result.put(BROWSER, UserAgentParser.detectBrowser(ua));
        result.put(BROWSER_VERSION, UserAgentParser.detectBrowserVersion(ua));
        result.put(OS, UserAgentParser.detectOS(ua));
        result.put(OS_VERSION, UserAgentParser.detectOSVersion(ua));
        result.put(DEVICE, UserAgentParser.detectDevice(ua));
        return result;
    }

    private static String detectBrowser(String ua) {
        if (ua.contains("chrome")) {
            return "chrome";
        }
        if (ua.contains("firefox")) {
            return "firefox";
        }
        if (ua.contains("safari") && !ua.contains("chrome")) {
            return "safari";
        }
        if (ua.contains("msie") || ua.contains("trident")) {
            return "ie";
        }
        if (ua.contains("edge")) {
            return "edge";
        }
        return "";
    }

    private static String detectBrowserVersion(String ua) {
        for (Pattern pattern : BROWSER_PATTERNS) {
            Matcher matcher = pattern.matcher(ua);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return "";
    }

    private static String detectOS(String ua) {
        if (ua.contains("windows")) {
            return "windows";
        }
        if (ua.contains("mac")) {
            return "macos";
        }
        if (ua.contains("linux")) {
            return "linux";
        }
        if (ua.contains("android")) {
            return "android";
        }
        if (ua.contains("iphone") || ua.contains("ipad")) {
            return "ios";
        }
        return "";
    }

    private static String detectOSVersion(String ua) {
        for (Pattern pattern : OS_PATTERNS) {
            Matcher matcher = pattern.matcher(ua);
            if (!matcher.find() || matcher.groupCount() <= 0) continue;
            String version = matcher.group(1);
            return version.length() >= 2 ? version.substring(0, 2) : version;
        }
        return "";
    }

    private static String detectDevice(String ua) {
        if (ua.contains("mobile")) {
            return "mobile";
        }
        if (ua.contains("tablet")) {
            return "tablet";
        }
        if (ua.contains("iphone")) {
            return "iphone";
        }
        if (ua.contains("ipad")) {
            return "ipad";
        }
        if (ua.contains("android")) {
            return "android";
        }
        return "desktop";
    }
}

