/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.tests;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.exchange.miner.Miner;

public class Minting {
    public static void main(String[] args) {
        double reward;
        double bank = 10000.0;
        double percent = 0.2;
        int minutesInYear = 525600;
        int maxMinutes = 100 * minutesInYear;
        double difficulty = 3.0E7;
        double lastReward = -1.0;
        LocalDateTime startDate = LocalDateTime.of(2025, 3, 28, 0, 0);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        for (int currentMinute = 0; bank > 0.0 && currentMinute <= maxMinutes; bank -= reward, ++currentMinute) {
            reward = bank * percent / (double)minutesInYear;
            if (lastReward == (reward = Math.floor(reward * 10000.0) / 10000.0)) continue;
            double miningCostForToken = difficulty * Miner.minerFor100kHashes / 100000.0 + Miner.gasForOneMinting;
            double tokenCostPrice = miningCostForToken / reward;
            int years = currentMinute / minutesInYear;
            int days = currentMinute % minutesInYear / 1440;
            int hours = currentMinute % 1440 / 60;
            int minutes = currentMinute % 60;
            LocalDateTime currentDate = startDate.plusMinutes(currentMinute);
            System.out.println("\u0412\u0440\u0435\u043c\u044f " + years + "\u0433 " + days + "\u0434 " + hours + "\u0447 " + minutes + "\u043c (" + currentDate.format(formatter) + "): \u043d\u0430\u0433\u0440\u0430\u0434\u0430 = " + reward + ", \u0431\u0430\u043d\u043a = " + String.format("%.4f", bank) + ", \u0441\u0435\u0431\u0435\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c = " + String.format("%.6f", tokenCostPrice) + ", \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c = " + difficulty);
            lastReward = reward;
        }
    }
}

