/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.token;

import java.util.ArrayList;
import java.util.List;
import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Utils;
import org.exchange.exchange.Place;

public class Search
extends Get {
    @Override
    public Response get() {
        String search_text = this.getString("search_text");
        String top = this.getString("top", "mining");
        Response response = new Response();
        if (Utils.isEmpty(search_text) || search_text.length() < 2) {
            List<Token> topList = null;
            if (top.equals("volume24")) {
                topList = Place.topVolume24.getTop();
            }
            if (topList == null) {
                topList = Send.topMining.getTop();
            }
            response.tokens = topList;
        } else {
            response.tokens = Search.searchTop(search_text);
        }
        return response;
    }

    public static List<Token> searchTop(String searchText) {
        ArrayList<Token> response = new ArrayList<Token>();
        for (String domain : Send.tokensSearch.get(searchText)) {
            Token token = Send.getToken(domain);
            if (token == null) continue;
            response.add(token);
        }
        return response;
    }

    class Response
    extends Get.Response {
        List<Token> tokens;

        Response() {
        }
    }
}

