/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;

public class InfiniteTimer {
    Timer timer;
    Callback callback;
    public final Duration interval;
    public final Duration stopAfter;
    long lastRestart = 0L;
    boolean isRunning = false;

    public InfiniteTimer(Callback callback, Duration inteval) {
        this(callback, inteval, Duration.ofDays(365L));
    }

    public InfiniteTimer(Callback callback, Duration interval, Duration stopAfter) {
        this.callback = callback;
        this.interval = interval;
        this.stopAfter = stopAfter;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public boolean isDisabled() {
        return this.lastRestart == 0L || System.currentTimeMillis() - this.lastRestart >= this.stopAfter.toMillis();
    }

    private void initializeTimer() {
        this.stop();
        this.lastRestart = System.currentTimeMillis();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - InfiniteTimer.this.lastRestart < InfiniteTimer.this.stopAfter.toMillis()) {
                    InfiniteTimer.this.onTimer();
                } else {
                    InfiniteTimer.this.timer.cancel();
                    InfiniteTimer.this.timer = null;
                }
            }
        }, this.interval.toMillis(), this.interval.toMillis());
    }

    public void onTimer() {
        if (this.isRunning) {
            return;
        }
        try {
            this.isRunning = true;
            this.callback.onTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.isRunning = false;
        }
    }

    public void runOnceAndStart() {
        this.onTimer();
        this.restart();
    }

    public void start() {
        this.restart();
    }

    public void restart() {
        if (this.isDisabled()) {
            this.initializeTimer();
        } else {
            this.lastRestart = System.currentTimeMillis();
        }
    }

    public static interface Callback {
        public void onTimer() throws Exception;
    }
}

