/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import net.vavilon.utils.Utils;

public class Settings {
    public static final String FILENAME = "settings.ini";

    public static String get(String app, String key) {
        return Settings.get(app, key, null);
    }

    public static String get(String app, String key, String def) {
        String settingsKey = (app + "_" + key).toUpperCase();
        String settingsValue = null;
        for (String line : Utils.readFileLines(FILENAME)) {
            String savedSettingKey;
            int index = line.indexOf("=");
            if (index == -1 || !(savedSettingKey = line.substring(0, index)).toUpperCase().equals(settingsKey)) continue;
            settingsValue = line.substring(index + 1).trim();
            break;
        }
        if (settingsValue == null) {
            Utils.appendFile(FILENAME, "\n" + settingsKey + "=");
        }
        if (Utils.isEmpty(settingsValue) && Utils.isEmpty(def)) {
            try {
                throw new RuntimeException(settingsKey + " has to be set in " + FILENAME);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return settingsValue == null ? def : settingsValue;
    }

    public static Long getLong(String app, String key) {
        return Settings.getLong(app, key, null);
    }

    public static Long getLong(String app, String key, Long def) {
        try {
            String str = Settings.get(app, key);
            return str == null ? def : Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Integer getInteger(String app, String key) {
        return Settings.getInteger(app, key, null);
    }

    public static Integer getInteger(String app, String key, Integer def) {
        try {
            String str = Settings.get(app, key);
            return str == null ? def : Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double getDouble(String app, String key) {
        return Settings.getDouble(app, key, null);
    }

    public static Double getDouble(String app, String key, Double def) {
        try {
            String str = Settings.get(app, key);
            return str == null ? def : Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

