/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.vavilon.servers.model.ContractException;

public class Utils {
    public static final Random random = new Random();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static String hash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : messageDigest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Double round(Double value) {
        return (double)Math.round(value * Math.pow(10.0, 4.0)) / Math.pow(10.0, 4.0);
    }

    public static Double roundDown(Double value) {
        if (value == null) {
            return null;
        }
        double scale = Math.pow(10.0, 4.0);
        return Math.floor(value * scale) / scale;
    }

    public static int random() {
        return Math.abs(random.nextInt());
    }

    public static Long currentTimeSec() {
        return (long)Math.ceil((double)new Date().getTime() / 1000.0);
    }

    public static Map<String, Object> toMap(Object obj) {
        return Utils.parseMap(gson.toJson(obj));
    }

    public static Map<String, Object> parseMap(String json) {
        return (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static Map<String, String> toStringMap(Object obj) {
        return (Map)gson.fromJson(gson.toJson(obj), new TypeToken<Map<String, String>>(){}.getType());
    }

    public static String readFile(String path) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static List<String> readFileLines(String path) {
        try {
            return Files.readAllLines(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<String> readFileLines(String path, String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : Utils.readFileLines(path)) {
            if (!line.trim().startsWith(prefix)) continue;
            lines.add(line);
        }
        return lines;
    }

    public static void writeFile(String path, String string) {
        try {
            String filepath = Utils.extractFilepath(path);
            File dir = new File(filepath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Files.write(Paths.get(path, new String[0]), string.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendFile(String path, String responseStr) {
        try {
            FileWriter errorLog = new FileWriter(path, true);
            errorLog.write(responseStr);
            errorLog.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String filePath) {
        try {
            Files.delete(Paths.get(filePath, new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String extractUrlPath(String url) {
        int idx = url.indexOf(63);
        return idx != -1 ? url.substring(0, idx) : url;
    }

    public static void deleteDirRecursively(String dirPath) {
        Path path = Paths.get(dirPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String source, String dest) {
        try {
            Files.copy(Paths.get(source, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String extractFilepath(String filepath) {
        if (filepath == null || filepath.isEmpty()) {
            return null;
        }
        int lastSlash = (filepath = filepath.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (lastSlash >= 0) {
            return filepath.substring(0, lastSlash + 1);
        }
        return null;
    }

    public static String extractFilename(String filepath) {
        if (filepath == null || filepath.isEmpty()) {
            return null;
        }
        int lastSlash = (filepath = filepath.replaceAll("\\\\", "/")).lastIndexOf(47);
        String name = lastSlash >= 0 ? filepath.substring(lastSlash + 1) : filepath;
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0) {
            return name.substring(0, lastDot);
        }
        return name;
    }

    public static String extractExtension(String filepath) {
        if (filepath == null || filepath.isEmpty()) {
            return null;
        }
        int lastSlash = (filepath = filepath.replaceAll("\\\\", "/")).lastIndexOf(47);
        String name = lastSlash >= 0 ? filepath.substring(lastSlash + 1) : filepath;
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0 && lastDot < name.length() - 1) {
            return name.substring(lastDot + 1);
        }
        return null;
    }

    public static List<String> getItems(String path, boolean recursive, boolean directories, boolean absolute, String prefix, String extension) {
        ArrayList<String> result = new ArrayList<String>();
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return result;
        }
        String ext = extension != null ? extension.toLowerCase() : null;
        String prefixLower = prefix != null ? prefix.toLowerCase() : null;
        File[] files = dir.listFiles();
        if (files == null) {
            return result;
        }
        for (File f : files) {
            boolean matchesPrefix;
            String fileName = f.getName();
            boolean bl = matchesPrefix = prefixLower == null || fileName.toLowerCase().startsWith(prefixLower);
            if (f.isDirectory()) {
                if (directories && matchesPrefix) {
                    String dirPath = absolute ? f.getAbsolutePath() : fileName;
                    result.add(dirPath.replace("\\", "/"));
                }
                if (!recursive) continue;
                result.addAll(Utils.getItems(f.getAbsolutePath(), true, directories, absolute, prefix, extension));
                continue;
            }
            if (directories || !f.isFile() || !matchesPrefix || ext != null && !fileName.toLowerCase().endsWith("." + ext)) continue;
            String filePath = absolute ? f.getAbsolutePath() : fileName;
            result.add(filePath.replace("\\", "/"));
        }
        return result;
    }

    public static List<String> getDirectories(String path) {
        return Utils.getItems(path, false, true, false, null, null);
    }

    public static List<String> getDirectories(String path, String prefix) {
        return Utils.getItems(path, false, true, false, prefix, null);
    }

    public static List<String> getFiles(String path) {
        return Utils.getItems(path, true, false, false, null, null);
    }

    public static List<String> getFiles(String path, String extension) {
        return Utils.getItems(path, false, false, false, null, extension);
    }

    public static List<String> getFiles(String path, String extension, String prefix) {
        return Utils.getItems(path, true, false, false, prefix, extension);
    }

    public static List<String> getFilesAbsolute(String path) {
        return Utils.getItems(path, false, false, true, null, null);
    }

    public static List<String> getFilesAbsolute(String path, String extension) {
        return Utils.getItems(path, false, false, true, null, extension);
    }

    public static List<String> getFilesRecAbsolute(String path, String extension) {
        return Utils.getItems(path, true, false, true, null, extension);
    }

    public static Map<String, Object> getFilesRecToMap(String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> files = Utils.getFilesRecAbsolute(path, null);
        for (String filePath : files) {
            String fileName = Utils.extractFilename(filePath) + "." + Utils.extractExtension(filePath);
            result.put(fileName, Utils.readFile(filePath));
        }
        return result;
    }

    public static List<String> getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        printWriter.flush();
        LinkedList<String> stack = new LinkedList<String>(Arrays.asList(writer.toString().split("\n\t")));
        return stack;
    }

    public static void disableCertificateValidation() throws Exception {
        TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCertificates, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }

    public Double last(List<Double> list) {
        return list.get(list.size() - 1);
    }

    public static String sortAndMerge(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.compareTo(b) < 0 ? a + b : b + a;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean contains(String str, String substr) {
        return Utils.isNotEmpty(str) && str.contains(substr);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isValidChars(String text, String charsStr) {
        for (int i = 0; i < text.length(); ++i) {
            if (charsStr.indexOf(text.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String toggle(String list, String str) {
        String[] split = Utils.isEmpty(list) ? new String[]{} : list.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(split));
        if (!set.remove(str)) {
            set.add(str);
        }
        return String.join((CharSequence)",", set);
    }

    public static List<String> list(String ... str) {
        return new ArrayList<String>(Arrays.asList(str));
    }

    public static List<Object> objectList(Object ... str) {
        return new ArrayList<Object>(Arrays.asList(str));
    }

    public static void error(String message) {
        throw new ContractException(message);
    }

    public void error(String message, Object data) {
        throw new ContractException(message, data);
    }
}

