/*
 * Decompiled with CFR 0.152.
 */
package org.exchange;

import com.metabrain.gdb.BigFile;
import java.time.Duration;
import net.vavilon.servers.model.Post;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Utils;
import org.exchange.Analytics;
import org.exchange.deposit.Bitcoin;
import org.exchange.deposit.DepositAddressLock;
import org.exchange.deposit.Ethereum;
import org.exchange.deposit.Lock;
import org.exchange.deposit.TronTrx;
import org.exchange.deposit.TronUsdt;
import org.exchange.exchange.bot.HedgeBot;

public class Deposit
extends Analytics {
    public static final InfiniteTimer tronUsdtChecker;
    public static final InfiniteTimer tronTrxChecker;
    public static final InfiniteTimer bitcoinChecker;
    public static final InfiniteTimer etheriumChecker;

    public Deposit(String masterNode) throws Exception {
        super(masterNode);
    }

    @Override
    public void start() throws Exception {
        super.start();
        HedgeBot.hedgeTokens.add("bitcoin");
        HedgeBot.hedgeTokens.add("ethereum");
        HedgeBot.hedgeTokens.add("tron");
    }

    @Override
    public Post getEndpoint(String uri) {
        switch (uri) {
            case "mfm-deposit/deposit_address_block": {
                return new DepositAddressLock();
            }
            case "mfm-deposit/lock": {
                return new Lock();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        if (BigFile.isDebugMode) {
            Utils.deleteDirRecursively("db-deposit");
        }
        tronUsdtChecker = new InfiniteTimer(new TronUsdt(), Duration.ofSeconds(10L), Duration.ofMinutes(30L));
        tronTrxChecker = new InfiniteTimer(new TronTrx(), Duration.ofSeconds(10L), Duration.ofMinutes(30L));
        bitcoinChecker = new InfiniteTimer(new Bitcoin(), Duration.ofMinutes(1L), Duration.ofMinutes(30L));
        etheriumChecker = new InfiniteTimer(new Ethereum(), Duration.ofSeconds(12L), Duration.ofMinutes(30L));
    }
}

