/*
 * Decompiled with CFR 0.152.
 */
package org.exchange;

import com.metabrain.gdb.model.String64;
import java.time.Duration;
import net.vavilon.servers.model.Post;
import net.vavilon.token.Send;
import net.vavilon.token.model.Account;
import net.vavilon.utils.InfiniteTimer;
import org.exchange.Deposit;
import org.exchange.miner.AccountInfo;
import org.exchange.miner.Miner;
import org.exchange.miner.MinerSend;
import org.exchange.miner.MinerUtils;
import org.exchange.miner.ToggleDomain;
import org.exchange.miner.Trans;
import org.exchange.miner.Withdrawal;
import org.exchange.miner.model.MinerAccount;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.TelegramUser;
import org.exchange.telegram.utils.FormatFront;

public class MinerFarm
extends Deposit {
    public MinerFarm(String masterNode) throws Exception {
        super(masterNode);
        Send.regAccount("usdt", MinerUtils.MINER_ADDRESS, MinerUtils.MINER_PASSWORD);
        Send.regAccount("usdt", MinerUtils.ENERGY_ADDRESS, MinerUtils.ENERGY_PASSWORD);
        int i = 0;
        while ((long)i < MinerUtils.minerAccountsByAddress.values.size()) {
            MinerAccount minerAccount = (MinerAccount)MinerUtils.minerAccountsByAddress.values.get(i);
            Account minerAddressAccount = Send.getAccount("usdt", minerAccount.minerAddress);
            if (minerAddressAccount != null && minerAddressAccount.balance >= FormatFront.round(minerAccount.tariff * (double)minerAccount.getDomainList().length)) {
                Miner.activeMinerAccountsByUserAddress.put(minerAccount.userAddress, minerAccount);
            }
            ++i;
        }
        Send.depositListeners.add(tran -> {
            if (tran.to.equals(MinerUtils.MINER_ADDRESS) && tran.domain.equals("usdt")) {
                MinerSend.request(MinerUtils.MINER_ADDRESS, tran.from, tran.amount, Send.tokenPass("usdt", MinerUtils.MINER_ADDRESS, MinerUtils.MINER_PASSWORD));
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        new InfiniteTimer(new Miner(), Duration.ofMinutes(1L)).start();
    }

    @Override
    public Post getEndpoint(String uri) {
        switch (uri) {
            case "mfm-miner/account": {
                return new AccountInfo();
            }
            case "mfm-miner/send": {
                return new MinerSend();
            }
            case "mfm-miner/toggle_domain": {
                return new ToggleDomain();
            }
            case "mfm-miner/withdrawal": {
                return new Withdrawal();
            }
            case "mfm-miner/trans": {
                return new Trans();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        int i = 1;
        while ((long)i < MinerUtils.minerAccountsByAddress.values.size()) {
            MinerAccount minerAccount = (MinerAccount)MinerUtils.minerAccountsByAddress.values.get(i);
            MinerUtils.userAddressByMinerAddress.put(minerAccount.minerAddress, new String64(minerAccount.userAddress));
            ++i;
        }
        Send.loaderListeners.add(tran -> {
            TelegramUser user;
            if (tran.domain.equals("usdt") && MinerUtils.userAddressByMinerAddress.get(tran.to) != null && (user = TelegramUtils.getUserByAddress(MinerUtils.userAddressByMinerAddress.get(tran.to).toString())) != null) {
                user.total_buy_energy += tran.amount.doubleValue();
                ++user.buy_energy_count;
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        });
    }
}

