/*
 * Decompiled with CFR 0.152.
 */
package org.exchange;

import java.time.Duration;
import net.vavilon.servers.model.Post;
import net.vavilon.token.Send;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Request;
import org.exchange.Airdrops;
import org.exchange.deposit.TronUsdt;
import org.exchange.telegram.Hook;
import org.exchange.telegram.Login;
import org.exchange.telegram.Messages;
import org.exchange.telegram.SubscriptionCheck;
import org.exchange.telegram.Telegram;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.TelegramUser;
import org.exchange.telegram.utils.Format;

public class TelegramBot
extends Airdrops {
    public TelegramBot(String masterNode) throws Exception {
        super(masterNode);
        Send.depositListeners.add(tran -> {
            if (tran.amount > 0.0) {
                Telegram.sendToAddress(tran.to, "you_have_received", Request.map("amount", Format.formatAmount(tran.amount, tran.domain), "from", Format.formatAddress(tran.from), "txid", Format.formatHashShort(tran.next_hash)));
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        new InfiniteTimer(new Messages(), Duration.ofMinutes(1L)).runOnceAndStart();
    }

    @Override
    public Post getEndpoint(String uri) {
        switch (uri) {
            case "mfm-telegram/hook": {
                return new Hook();
            }
            case "mfm-telegram/login": {
                return new Login();
            }
            case "mfm-telegram/subscription_check": {
                return new SubscriptionCheck();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        if (TelegramBot.isNeedRecalc()) {
            int i = 1;
            while ((long)i < TelegramUtils.usersByUserId.values.size()) {
                TelegramUser user = (TelegramUser)TelegramUtils.usersByUserId.values.get(i);
                user.clear();
                TelegramUtils.usersByUserId.put("" + user.id, user);
                ++i;
            }
        }
        Send.loaderListeners.add(tran -> {
            TelegramUser user;
            if (tran.from.equals(TronUsdt.ADDRESS) && (user = TelegramUtils.getUserByAddress(tran.to)) != null) {
                user.total_deposited += tran.amount.doubleValue();
                ++user.deposit_count;
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        });
    }
}

