/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.airdrop;

import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.exchange.airdrop.AirdropUtils;
import org.exchange.airdrop.model.Airdrop;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.TelegramUser;

public class AirdropInfo
extends Get {
    @Override
    public Get.Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddressNotRequired("address");
        Airdrop airdrop = AirdropUtils.airdropByDomain.get(domain);
        if (airdrop == null) {
            Utils.error("airdrop is finished");
        }
        airdrop.referral_link = "https://t.me/vavilon_org_bot?start=" + domain;
        if (Utils.isNotEmpty(address)) {
            airdrop.rewarded = AirdropUtils.isRewarded(airdrop.domain, address);
            TelegramUser user = TelegramUtils.getUserByAddress(address);
            if (user != null && Utils.isNotEmpty(user.username)) {
                airdrop.referral_link = airdrop.referral_link + "_with_" + user.username;
                airdrop.referral_count = user.referral_count;
            }
        }
        airdrop.account = Send.getAccount(domain, AirdropUtils.ADDRESS);
        airdrop.token = Send.getToken(airdrop.domain);
        Response response = new Response();
        response.airdrop = airdrop;
        return response;
    }

    public static Response request(String domain) {
        try {
            return (Response)new AirdropInfo().run(null, Request.map("domain", domain));
        }
        catch (Exception e) {
            return null;
        }
    }

    public class Response
    extends Get.Response {
        public Airdrop airdrop;
    }
}

