/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.craft.model;

import com.metabrain.gdb.Top;
import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.utils.Request;

public class Recipe
implements BigArrayCell,
Top.TopId {
    public String domain;
    public String prefix;
    public String recipe;
    public Map<String, Double> items = new HashMap<String, Double>();
    public Map<String, Double> balances = new HashMap<String, Double>();
    public long crafted;

    public Recipe() {
    }

    public Recipe(String recipe) {
        this.recipe = recipe;
    }

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addString64(this.recipe);
        data.addLong(this.crafted);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.recipe = data.readString64();
        this.crafted = data.readLong();
        Map<String, String> map = Request.parseQuery(this.recipe);
        for (String key : map.keySet()) {
            if (key.equals("domain")) {
                this.domain = map.get(key);
                this.prefix = this.domain.contains("_") ? this.domain.substring(0, this.domain.indexOf("_")) : null;
                continue;
            }
            this.items.put(key, Double.valueOf(map.get(key)));
        }
    }

    @Override
    public String getId() {
        return this.recipe;
    }
}

