/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.deposit;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.model.LongCell;
import com.metabrain.gdb.model.String64;
import net.vavilon.NodeInit;
import net.vavilon.token.Send;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Settings;
import net.vavilon.utils.Utils;
import org.exchange.deposit.DepositUtils;
import org.exchange.deposit.model.AddressLock;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.http.HttpService;

public class Ethereum
implements InfiniteTimer.Callback {
    public static final String NETWORK = "e";
    public static final String ETHEREUM = "ethereum";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", Ethereum.class.getSimpleName() + "_deposit_address");
    public static final String CONTRACT = "mfm-token/send?n=e&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", Ethereum.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    private static long LAST_SCANNED_HEIGHT = 23384082L;
    public static double GWEI_IN_ETHERIUM = 1.0E18;
    public static double MIN_DEPOSIT_ETHER = 1.0E-4;
    public static final long BLOCK_GENERATE_SECONDS = 12L;
    BigArray<LongCell> ethereumLastScannedHeight = new BigArray<LongCell>("deposit", "ethereumLastScannedHeight", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://ethereum-rpc.publicnode.com"));
        long lastScannedHeight = this.ethereumLastScannedHeight.size() > 0L ? this.ethereumLastScannedHeight.get((long)(this.ethereumLastScannedHeight.size() - 1L)).value : LAST_SCANNED_HEIGHT;
        while (true) {
            EthBlock block = (EthBlock)web3j.ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber(lastScannedHeight), true).send();
            for (EthBlock.TransactionResult txResult : block.getBlock().getTransactions()) {
                double amountEther;
                EthBlock.TransactionObject tx = (EthBlock.TransactionObject)txResult.get();
                if (!DEPOSIT_ADDRESS.equalsIgnoreCase(tx.getTo()) || !((amountEther = tx.getValue().doubleValue() / GWEI_IN_ETHERIUM) >= MIN_DEPOSIT_ETHER)) continue;
                String userAddress = NodeInit.USER_ADDRESS;
                AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
                if (lock != null) {
                    userAddress = lock.user_address;
                }
                double depositAmount = Utils.roundDown(amountEther);
                DepositUtils.tranIdToUserAddress.put(tx.getHash(), new String64(userAddress));
                Send.request(CONTRACT, ETHEREUM, ADDRESS, userAddress, depositAmount, Send.tokenPass(ETHEREUM, ADDRESS, PASSWORD), null);
            }
            this.ethereumLastScannedHeight.add(new LongCell(lastScannedHeight));
            ++lastScannedHeight;
        }
    }
}

