/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.docs;

import com.metabrain.gdb.BigChain;
import com.metabrain.gdb.BigMap;
import com.metabrain.gdb.model.String128;
import java.util.ArrayList;
import java.util.List;
import org.exchange.docs.model.Proposal;
import org.exchange.events.EventsUtils;
import org.exchange.telegram.Telegram;

public class DocsUtils
extends EventsUtils {
    public static final String APP = "docs";
    public static final String PROPOSAL = "proposal";
    public static final String DOCS_PATH = "mfm-landing/docs/";
    private static final BigMap<Proposal> proposalsByProposalFile = new BigMap<Proposal>("docs", "proposalsByFile", Proposal.class);
    private static final BigChain<String128> proposalsHistory = new BigChain<String128>("docs", "proposalsHistory", String128.class);
    List<Proposal> newProposals = new ArrayList<Proposal>();

    static Proposal getProposal(String proposalFile) {
        return proposalsByProposalFile.get(proposalFile);
    }

    static List<Proposal> getProposals(String originalFile, long offset, long size) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        for (String128 proposalFile : proposalsHistory.getPageReverse(originalFile, offset, size)) {
            result.add(DocsUtils.getProposal(proposalFile.toString()));
        }
        return result;
    }

    void putProposal(Proposal proposal) {
        this.newProposals.add(proposal);
    }

    @Override
    public void commit() {
        super.commit();
        if (this.newProposals.size() > 0) {
            for (Proposal proposal : this.newProposals) {
                proposalsByProposalFile.put(proposal.getId(), proposal);
                proposalsHistory.addLast(proposal.originalFile, new String128(proposal.getId()));
            }
            this.newProposals.clear();
        }
    }

    @Override
    public void run() {
        String utm_source;
        String referer = this.headers.getOrDefault("Referer", (String)this.headers.get("referer"));
        if (referer != null) {
            this.trackEvent("new_guest", referer, (String)this.meta.get("ip"), (String)this.meta.get("ip"));
            Telegram.sendToAdmin(referer, "new_guest", this.scriptPath, "" + this.time());
        }
        if ((utm_source = this.getString("utm_source")) != null) {
            String utm_campaign = this.getString("utm_campaign");
            this.trackEvent("new_guest", referer, (String)this.meta.get("ip"), (String)this.meta.get("ip"));
            Telegram.sendToAdmin(utm_source, "new_guest", utm_campaign, "" + this.time());
        }
    }
}

