/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.docs;

import ai.vavilon.Translator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Settings;
import net.vavilon.utils.Utils;

public class SiteMap
extends Get {
    public static final String site = "https://" + Settings.get("https", "site_domain", "vavilon.org") + "/";

    @Override
    public Response get() {
        ArrayList<Link> links = new ArrayList<Link>();
        this.addWithLanguages(links, site);
        for (String filename : Utils.getFiles("mfm-landing/docs", "md")) {
            this.addWithLanguages2(links, site + "mfm-landing/docs/" + filename);
        }
        int i = 1;
        while ((long)i < Send.tokensByDomain.values.size()) {
            Token token = (Token)Send.tokensByDomain.values.get(i);
            String baseUrl = site + "mfm-landing/profile?domain=" + token.domain;
            this.addWithLanguages(links, baseUrl);
            ++i;
        }
        return new Response(links);
    }

    private void addWithLanguages(List<Link> links, String baseUrl) {
        links.add(new Link(baseUrl, 1.0));
        for (String languageCode : Translator.LANGUAGES.values()) {
            links.add(new Link(baseUrl + (baseUrl.contains("?") ? "&" : "?") + "lang=" + languageCode));
        }
    }

    private void addWithLanguages2(List<Link> links, String baseUrl) {
        for (String languageCode : Translator.LANGUAGES.values()) {
            links.add(new Link(Translator.getLocalizedFile(baseUrl, languageCode)));
        }
    }

    class Response
    extends Get.Response {
        public List<Link> links;

        public Response(List<Link> links) {
            this.links = links;
        }
    }

    class Link {
        String url;
        String lastmod = LocalDate.now().toString();
        String changefreq = "daily";
        double priority = 0.8;

        public Link(String url) {
            this.url = url;
        }

        public Link(String url, double priority) {
            this.url = url;
            this.priority = priority;
        }
    }
}

