/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.docs.model;

import com.metabrain.gdb.Top;
import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import net.vavilon.utils.Utils;

public class Proposal
implements BigArrayCell,
Top.TopId {
    public String originalFile;
    public String originalHash;
    public String user;
    public Long time;
    public String proposalData;
    public boolean outdated;

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addString64(this.originalFile);
        data.addString64(this.originalHash);
        data.addString64(this.user);
        data.addLong(this.time);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.originalFile = data.readString64();
        this.originalHash = data.readString64();
        this.user = data.readString64();
        this.time = data.readLong();
    }

    @Override
    public String getId() {
        return this.getProposalFile();
    }

    public String getProposalFile() {
        return this.getProposalDir() + "/" + this.user + "." + Utils.extractExtension(this.originalFile);
    }

    public String getProposalDir() {
        String filepath = Utils.extractFilepath(this.originalFile);
        String filename = Utils.extractFilename(this.originalFile);
        return filepath + filename + "/" + "proposal";
    }
}

